/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;

@XStreamAlias(value="xml")
public class WxDepositRefundRequest
extends BaseWxPayRequest {
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @Required
    @XStreamAlias(value="refund_fee")
    private Integer refundFee;
    @XStreamAlias(value="refund_desc")
    private String refundDesc;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (this.transactionId == null && this.outTradeNo == null) {
            throw new WxPayException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        if (this.transactionId != null) {
            map.put("transaction_id", this.transactionId);
        }
        if (this.outTradeNo != null) {
            map.put("out_trade_no", this.outTradeNo);
        }
        map.put("out_refund_no", this.outRefundNo);
        map.put("refund_fee", this.refundFee.toString());
        if (this.refundDesc != null) {
            map.put("refund_desc", this.refundDesc);
        }
    }

    public static WxDepositRefundRequestBuilder newBuilder() {
        return new WxDepositRefundRequestBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public Integer getRefundFee() {
        return this.refundFee;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    @Override
    public String toString() {
        return "WxDepositRefundRequest(transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", outRefundNo=" + this.getOutRefundNo() + ", refundFee=" + this.getRefundFee() + ", refundDesc=" + this.getRefundDesc() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxDepositRefundRequest)) {
            return false;
        }
        WxDepositRefundRequest other = (WxDepositRefundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$refundFee = this.getRefundFee();
        Integer other$refundFee = other.getRefundFee();
        if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        String this$refundDesc = this.getRefundDesc();
        String other$refundDesc = other.getRefundDesc();
        return !(this$refundDesc == null ? other$refundDesc != null : !this$refundDesc.equals(other$refundDesc));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxDepositRefundRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $refundFee = this.getRefundFee();
        result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        String $refundDesc = this.getRefundDesc();
        result = result * 59 + ($refundDesc == null ? 43 : $refundDesc.hashCode());
        return result;
    }

    public WxDepositRefundRequest() {
    }

    public WxDepositRefundRequest(String transactionId, String outTradeNo, String outRefundNo, Integer refundFee, String refundDesc) {
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
        this.outRefundNo = outRefundNo;
        this.refundFee = refundFee;
        this.refundDesc = refundDesc;
    }

    public static class WxDepositRefundRequestBuilder {
        private String transactionId;
        private String outTradeNo;
        private String outRefundNo;
        private Integer refundFee;
        private String refundDesc;

        WxDepositRefundRequestBuilder() {
        }

        public WxDepositRefundRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxDepositRefundRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxDepositRefundRequestBuilder outRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
            return this;
        }

        public WxDepositRefundRequestBuilder refundFee(Integer refundFee) {
            this.refundFee = refundFee;
            return this;
        }

        public WxDepositRefundRequestBuilder refundDesc(String refundDesc) {
            this.refundDesc = refundDesc;
            return this;
        }

        public WxDepositRefundRequest build() {
            return new WxDepositRefundRequest(this.transactionId, this.outTradeNo, this.outRefundNo, this.refundFee, this.refundDesc);
        }

        public String toString() {
            return "WxDepositRefundRequest.WxDepositRefundRequestBuilder(transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ", outRefundNo=" + this.outRefundNo + ", refundFee=" + this.refundFee + ", refundDesc=" + this.refundDesc + ")";
        }
    }
}

