/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;

@XStreamAlias(value="xml")
public class WxDepositUnifiedOrderRequest
extends BaseWxPayRequest {
    @Required
    @XStreamAlias(value="body")
    private String body;
    @Required
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @Required
    @XStreamAlias(value="spbill_create_ip")
    private String spbillCreateIp;
    @Required
    @XStreamAlias(value="notify_url")
    private String notifyUrl;
    @Required
    @XStreamAlias(value="trade_type")
    private String tradeType;
    @XStreamAlias(value="openid")
    private String openid;
    @XStreamAlias(value="detail")
    private String detail;
    @XStreamAlias(value="attach")
    private String attach;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="time_start")
    private String timeStart;
    @XStreamAlias(value="time_expire")
    private String timeExpire;

    @Override
    protected void checkConstraints() throws WxPayException {
        if ("JSAPI".equals(this.tradeType) && this.openid == null) {
            throw new WxPayException("\u5f53trade_type\u4e3aJSAPI\u65f6\uff0copenid\u4e3a\u5fc5\u586b\u53c2\u6570");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("body", this.body);
        map.put("out_trade_no", this.outTradeNo);
        map.put("total_fee", this.totalFee.toString());
        map.put("spbill_create_ip", this.spbillCreateIp);
        map.put("notify_url", this.notifyUrl);
        map.put("trade_type", this.tradeType);
        if (this.openid != null) {
            map.put("openid", this.openid);
        }
        if (this.detail != null) {
            map.put("detail", this.detail);
        }
        if (this.attach != null) {
            map.put("attach", this.attach);
        }
        if (this.feeType != null) {
            map.put("fee_type", this.feeType);
        }
        if (this.timeStart != null) {
            map.put("time_start", this.timeStart);
        }
        if (this.timeExpire != null) {
            map.put("time_expire", this.timeExpire);
        }
    }

    public static WxDepositUnifiedOrderRequestBuilder newBuilder() {
        return new WxDepositUnifiedOrderRequestBuilder();
    }

    public String getBody() {
        return this.body;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public String getSpbillCreateIp() {
        return this.spbillCreateIp;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public String getTimeExpire() {
        return this.timeExpire;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setTimeStart(String timeStart) {
        this.timeStart = timeStart;
    }

    public void setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
    }

    @Override
    public String toString() {
        return "WxDepositUnifiedOrderRequest(body=" + this.getBody() + ", outTradeNo=" + this.getOutTradeNo() + ", totalFee=" + this.getTotalFee() + ", spbillCreateIp=" + this.getSpbillCreateIp() + ", notifyUrl=" + this.getNotifyUrl() + ", tradeType=" + this.getTradeType() + ", openid=" + this.getOpenid() + ", detail=" + this.getDetail() + ", attach=" + this.getAttach() + ", feeType=" + this.getFeeType() + ", timeStart=" + this.getTimeStart() + ", timeExpire=" + this.getTimeExpire() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxDepositUnifiedOrderRequest)) {
            return false;
        }
        WxDepositUnifiedOrderRequest other = (WxDepositUnifiedOrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$spbillCreateIp = this.getSpbillCreateIp();
        String other$spbillCreateIp = other.getSpbillCreateIp();
        if (this$spbillCreateIp == null ? other$spbillCreateIp != null : !this$spbillCreateIp.equals(other$spbillCreateIp)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        String this$openid = this.getOpenid();
        String other$openid = other.getOpenid();
        if (this$openid == null ? other$openid != null : !this$openid.equals(other$openid)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        String this$attach = this.getAttach();
        String other$attach = other.getAttach();
        if (this$attach == null ? other$attach != null : !this$attach.equals(other$attach)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        String this$timeStart = this.getTimeStart();
        String other$timeStart = other.getTimeStart();
        if (this$timeStart == null ? other$timeStart != null : !this$timeStart.equals(other$timeStart)) {
            return false;
        }
        String this$timeExpire = this.getTimeExpire();
        String other$timeExpire = other.getTimeExpire();
        return !(this$timeExpire == null ? other$timeExpire != null : !this$timeExpire.equals(other$timeExpire));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxDepositUnifiedOrderRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $spbillCreateIp = this.getSpbillCreateIp();
        result = result * 59 + ($spbillCreateIp == null ? 43 : $spbillCreateIp.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        String $openid = this.getOpenid();
        result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        String $attach = this.getAttach();
        result = result * 59 + ($attach == null ? 43 : $attach.hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        String $timeStart = this.getTimeStart();
        result = result * 59 + ($timeStart == null ? 43 : $timeStart.hashCode());
        String $timeExpire = this.getTimeExpire();
        result = result * 59 + ($timeExpire == null ? 43 : $timeExpire.hashCode());
        return result;
    }

    public WxDepositUnifiedOrderRequest() {
    }

    public WxDepositUnifiedOrderRequest(String body, String outTradeNo, Integer totalFee, String spbillCreateIp, String notifyUrl, String tradeType, String openid, String detail, String attach, String feeType, String timeStart, String timeExpire) {
        this.body = body;
        this.outTradeNo = outTradeNo;
        this.totalFee = totalFee;
        this.spbillCreateIp = spbillCreateIp;
        this.notifyUrl = notifyUrl;
        this.tradeType = tradeType;
        this.openid = openid;
        this.detail = detail;
        this.attach = attach;
        this.feeType = feeType;
        this.timeStart = timeStart;
        this.timeExpire = timeExpire;
    }

    public static class WxDepositUnifiedOrderRequestBuilder {
        private String body;
        private String outTradeNo;
        private Integer totalFee;
        private String spbillCreateIp;
        private String notifyUrl;
        private String tradeType;
        private String openid;
        private String detail;
        private String attach;
        private String feeType;
        private String timeStart;
        private String timeExpire;

        WxDepositUnifiedOrderRequestBuilder() {
        }

        public WxDepositUnifiedOrderRequestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder totalFee(Integer totalFee) {
            this.totalFee = totalFee;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder spbillCreateIp(String spbillCreateIp) {
            this.spbillCreateIp = spbillCreateIp;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder tradeType(String tradeType) {
            this.tradeType = tradeType;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder openid(String openid) {
            this.openid = openid;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder attach(String attach) {
            this.attach = attach;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder feeType(String feeType) {
            this.feeType = feeType;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder timeStart(String timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public WxDepositUnifiedOrderRequestBuilder timeExpire(String timeExpire) {
            this.timeExpire = timeExpire;
            return this;
        }

        public WxDepositUnifiedOrderRequest build() {
            return new WxDepositUnifiedOrderRequest(this.body, this.outTradeNo, this.totalFee, this.spbillCreateIp, this.notifyUrl, this.tradeType, this.openid, this.detail, this.attach, this.feeType, this.timeStart, this.timeExpire);
        }

        public String toString() {
            return "WxDepositUnifiedOrderRequest.WxDepositUnifiedOrderRequestBuilder(body=" + this.body + ", outTradeNo=" + this.outTradeNo + ", totalFee=" + this.totalFee + ", spbillCreateIp=" + this.spbillCreateIp + ", notifyUrl=" + this.notifyUrl + ", tradeType=" + this.tradeType + ", openid=" + this.openid + ", detail=" + this.detail + ", attach=" + this.attach + ", feeType=" + this.feeType + ", timeStart=" + this.timeStart + ", timeExpire=" + this.timeExpire + ")";
        }
    }
}

