/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.example;

import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferQueryResult;
import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferRequest;
import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BusinessOperationTransferService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import java.util.Arrays;

public class BusinessOperationTransferExample {
    private WxPayService wxPayService;
    private BusinessOperationTransferService businessOperationTransferService;

    public void init() {
        WxPayConfig config = new WxPayConfig();
        config.setAppId("your_app_id");
        config.setMchId("your_mch_id");
        config.setMchKey("your_mch_key");
        config.setKeyPath("path_to_your_cert.p12");
        this.wxPayService = new WxPayServiceImpl();
        this.wxPayService.setConfig(config);
        this.businessOperationTransferService = this.wxPayService.getBusinessOperationTransferService();
    }

    public void createOperationTransferExample() {
        try {
            BusinessOperationTransferRequest.TransferSceneReportInfo reportInfo = new BusinessOperationTransferRequest.TransferSceneReportInfo();
            reportInfo.setInfoType("\u6d3b\u52a8\u540d\u79f0");
            reportInfo.setInfoContent("\u65b0\u4f1a\u5458\u6709\u793c");
            BusinessOperationTransferRequest request = BusinessOperationTransferRequest.newBuilder().appid("your_app_id").outBillNo("OT" + System.currentTimeMillis()).transferSceneId("2001").transferSceneReportInfos(Arrays.asList(reportInfo)).openid("user_openid").userName("\u5f20\u4e09").transferAmount(100).transferRemark("\u8fd0\u8425\u6d3b\u52a8\u5956\u52b1").userRecvPerception("\u73b0\u91d1\u5956\u52b1").notifyUrl("https://your-domain.com/notify").build();
            BusinessOperationTransferResult result = this.businessOperationTransferService.createOperationTransfer(request);
            System.out.println("\u8f6c\u8d26\u6210\u529f\uff01");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u5355\u636e\u72b6\u6001: " + result.getState());
            System.out.println("\u8df3\u8f6c\u9886\u53d6\u9875\u9762\u7684package\u4fe1\u606f: " + result.getPackageInfo());
            System.out.println("\u521b\u5efa\u65f6\u95f4: " + result.getCreateTime());
        }
        catch (WxPayException e) {
            System.err.println("\u8f6c\u8d26\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void queryByOutBillNoExample() {
        try {
            String outBillNo = "OT1640995200000";
            BusinessOperationTransferQueryResult result = this.businessOperationTransferService.queryOperationTransferByOutBillNo(outBillNo);
            System.out.println("\u67e5\u8be2\u6210\u529f\uff01");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u8f6c\u8d26\u72b6\u6001: " + result.getTransferState());
            System.out.println("\u8f6c\u8d26\u91d1\u989d: " + result.getTransferAmount() + "\u5206");
            System.out.println("\u521b\u5efa\u65f6\u95f4: " + result.getCreateTime());
            System.out.println("\u66f4\u65b0\u65f6\u95f4: " + result.getUpdateTime());
        }
        catch (WxPayException e) {
            System.err.println("\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void queryByTransferBillNoExample() {
        try {
            String transferBillNo = "1040000071100999991182020050700019480001";
            BusinessOperationTransferQueryResult result = this.businessOperationTransferService.queryOperationTransferByTransferBillNo(transferBillNo);
            System.out.println("\u67e5\u8be2\u6210\u529f\uff01");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u8fd0\u8425\u573a\u666fID: " + result.getOperationSceneId());
            System.out.println("\u8f6c\u8d26\u72b6\u6001: " + result.getTransferState());
        }
        catch (WxPayException e) {
            System.err.println("\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BusinessOperationTransferExample example = new BusinessOperationTransferExample();
        example.init();
        example.createOperationTransferExample();
    }
}

