/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferQueryRequest;
import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferQueryResult;
import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferRequest;
import com.github.binarywang.wxpay.bean.transfer.BusinessOperationTransferResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BusinessOperationTransferService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessOperationTransferServiceImpl
implements BusinessOperationTransferService {
    private static final Logger log = LoggerFactory.getLogger(BusinessOperationTransferServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService wxPayService;

    @Override
    public BusinessOperationTransferResult createOperationTransfer(BusinessOperationTransferRequest request) throws WxPayException {
        if (StringUtils.isEmpty((CharSequence)request.getAppid())) {
            request.setAppid(this.wxPayService.getConfig().getAppId());
        }
        String url = String.format("%s/v3/fund-app/mch-transfer/transfer-bills", this.wxPayService.getPayBaseUrl());
        if (StringUtils.isNotEmpty((CharSequence)request.getUserName())) {
            X509Certificate validCertificate = this.wxPayService.getConfig().getVerifier().getValidCertificate();
            RsaCryptoUtil.encryptFields(request, validCertificate);
        }
        String response = this.wxPayService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusinessOperationTransferResult)GSON.fromJson(response, BusinessOperationTransferResult.class);
    }

    @Override
    public BusinessOperationTransferQueryResult queryOperationTransfer(BusinessOperationTransferQueryRequest request) throws WxPayException {
        if (StringUtils.isNotEmpty((CharSequence)request.getOutBillNo())) {
            return this.queryOperationTransferByOutBillNo(request.getOutBillNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTransferBillNo())) {
            return this.queryOperationTransferByTransferBillNo(request.getTransferBillNo());
        }
        throw new WxPayException("\u5546\u6237\u5355\u53f7(out_bill_no)\u548c\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7(transfer_bill_no)\u5fc5\u987b\u63d0\u4f9b\u5176\u4e2d\u4e00\u4e2a");
    }

    @Override
    public BusinessOperationTransferQueryResult queryOperationTransferByOutBillNo(String outBillNo) throws WxPayException {
        String url = String.format("%s/v3/fund-app/mch-transfer/transfer-bills/out-bill-no/%s", this.wxPayService.getPayBaseUrl(), outBillNo);
        String response = this.wxPayService.getV3(url);
        return (BusinessOperationTransferQueryResult)GSON.fromJson(response, BusinessOperationTransferQueryResult.class);
    }

    @Override
    public BusinessOperationTransferQueryResult queryOperationTransferByTransferBillNo(String transferBillNo) throws WxPayException {
        String url = String.format("%s/v3/fund-app/mch-transfer/transfer-bills/transfer-bill-no/%s", this.wxPayService.getPayBaseUrl(), transferBillNo);
        String response = this.wxPayService.getV3(url);
        return (BusinessOperationTransferQueryResult)GSON.fromJson(response, BusinessOperationTransferQueryResult.class);
    }

    public BusinessOperationTransferServiceImpl(WxPayService wxPayService) {
        this.wxPayService = wxPayService;
    }
}

