/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.marketing.payroll.AuthRecordRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.AuthRecordResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.AuthenticationsResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.PayrollTransferBatchesRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.PayrollTransferBatchesResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.PreOrderRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.PreOrderResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.PreOrderWithAuthRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.PreOrderWithAuthResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.RelationsRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.RelationsResult;
import com.github.binarywang.wxpay.bean.marketing.payroll.TokensRequest;
import com.github.binarywang.wxpay.bean.marketing.payroll.TokensResult;
import com.github.binarywang.wxpay.bean.result.WxPayApplyBillV3Result;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PayrollService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayrollServiceImpl
implements PayrollService {
    private static final Logger log = LoggerFactory.getLogger(PayrollServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public TokensResult payrollCardTokens(TokensRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/tokens", this.payService.getPayBaseUrl());
        try {
            String userName = RsaCryptoUtil.encryptOAEP(request.getUserName(), this.payService.getConfig().getVerifier().getValidCertificate());
            request.setUserName(userName);
            String idCardNumber = RsaCryptoUtil.encryptOAEP(request.getIdCardNumber(), this.payService.getConfig().getVerifier().getValidCertificate());
            request.setIdCardNumber(idCardNumber);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("\u52a0\u5bc6\u5f02\u5e38!", e);
        }
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (TokensResult)GSON.fromJson(response, TokensResult.class);
    }

    @Override
    public RelationsResult payrollCardRelations(RelationsRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/relations/%s", this.payService.getPayBaseUrl(), request.getOpenid());
        String query = String.format("?sub_mchid=%s", request.getSubMchid());
        if (StringUtils.isNotEmpty((CharSequence)request.getAppid())) {
            query = query + "&appid=" + request.getAppid();
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSubAppid())) {
            query = query + "&sub_appid=" + request.getSubAppid();
        }
        String response = this.payService.getV3(url + query);
        return (RelationsResult)GSON.fromJson(response, RelationsResult.class);
    }

    @Override
    public PreOrderResult payrollCardPreOrder(PreOrderRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/authentications/pre-order", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (PreOrderResult)GSON.fromJson(response, PreOrderResult.class);
    }

    @Override
    public AuthenticationsResult payrollCardAuthenticationsNumber(String subMchid, String authenticateNumber) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/authentications/%s", this.payService.getPayBaseUrl(), authenticateNumber);
        String query = String.format("?sub_mchid=%s", subMchid);
        String response = this.payService.getV3(url + query);
        return (AuthenticationsResult)GSON.fromJson(response, AuthenticationsResult.class);
    }

    @Override
    public AuthRecordResult payrollCardAuthentications(AuthRecordRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/authentications", this.payService.getPayBaseUrl());
        String query = String.format("?openid=%s&sub_mchid=%s&authenticate_date=%s", request.getOpenid(), request.getAppid(), request.getSubMchid(), request.getAuthenticateDate());
        if (StringUtils.isNotEmpty((CharSequence)request.getAppid())) {
            query = query + "&appid=" + request.getAppid();
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAppid())) {
            query = query + "&sub_appid=" + request.getSubAppid();
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAuthenticateState())) {
            query = query + "&authenticate_state=" + request.getAuthenticateState();
        }
        String response = this.payService.getV3(url + query);
        return (AuthRecordResult)GSON.fromJson(response, AuthRecordResult.class);
    }

    @Override
    public PreOrderWithAuthResult payrollCardPreOrderWithAuth(PreOrderWithAuthRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/authentications/pre-order-with-auth", this.payService.getPayBaseUrl());
        try {
            String userName = RsaCryptoUtil.encryptOAEP(request.getUserName(), this.payService.getConfig().getVerifier().getValidCertificate());
            request.setUserName(userName);
            String idCardNumber = RsaCryptoUtil.encryptOAEP(request.getIdCardNumber(), this.payService.getConfig().getVerifier().getValidCertificate());
            request.setIdCardNumber(idCardNumber);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u5f02\u5e38!", e);
        }
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (PreOrderWithAuthResult)GSON.fromJson(response, PreOrderWithAuthResult.class);
    }

    @Override
    public WxPayApplyBillV3Result merchantFundWithdrawBillType(String billType, String billDate, String tarType) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/withdraw/bill-type/%s", this.payService.getPayBaseUrl(), billType);
        String query = String.format("?bill_date=%s", billDate);
        if (StringUtils.isNotBlank((CharSequence)tarType)) {
            query = query + String.format("&tar_type=%s", tarType);
        }
        String response = this.payService.getV3(url + query);
        return (WxPayApplyBillV3Result)GSON.fromJson(response, WxPayApplyBillV3Result.class);
    }

    @Override
    public PayrollTransferBatchesResult payrollCardTransferBatches(PayrollTransferBatchesRequest request) throws WxPayException {
        String url = String.format("%s/v3/payroll-card/transfer-batches", this.payService.getPayBaseUrl());
        if (request.getTransferDetailList() != null && !request.getTransferDetailList().isEmpty()) {
            for (PayrollTransferBatchesRequest.TransferDetail detail : request.getTransferDetailList()) {
                RsaCryptoUtil.encryptFields(detail, this.payService.getConfig().getVerifier().getValidCertificate());
            }
        }
        String response = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (PayrollTransferBatchesResult)GSON.fromJson(response, PayrollTransferBatchesResult.class);
    }

    public PayrollServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

