/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.realname.RealNameRequest;
import com.github.binarywang.wxpay.bean.realname.RealNameResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.RealNameService;
import com.github.binarywang.wxpay.service.WxPayService;

public class RealNameServiceImpl
implements RealNameService {
    private final WxPayService payService;

    @Override
    public RealNameResult queryRealName(RealNameRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/userinfo/realnameauth/query";
        String responseContent = this.payService.post(url, request.toXML(), true);
        RealNameResult result = BaseWxPayResult.fromXML(responseContent, RealNameResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public RealNameResult queryRealName(String openid) throws WxPayException {
        RealNameRequest request = RealNameRequest.newBuilder().openid(openid).build();
        return this.queryRealName(request);
    }

    public RealNameServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

