/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionCancelRequest;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionCancelResult;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionInstantBillingRequest;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionInstantBillingResult;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionQueryResult;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionScheduleRequest;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionScheduleResult;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionTransactionQueryRequest;
import com.github.binarywang.wxpay.bean.subscriptionbilling.SubscriptionTransactionQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.SubscriptionBillingService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionBillingServiceImpl
implements SubscriptionBillingService {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionBillingServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public SubscriptionScheduleResult scheduleSubscription(SubscriptionScheduleRequest request) throws WxPayException {
        String url = String.format("%s/v3/subscription-billing/schedule", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (SubscriptionScheduleResult)GSON.fromJson(response, SubscriptionScheduleResult.class);
    }

    @Override
    public SubscriptionQueryResult querySubscription(String subscriptionId) throws WxPayException {
        String url = String.format("%s/v3/subscription-billing/schedule/%s", this.payService.getPayBaseUrl(), subscriptionId);
        String response = this.payService.getV3(url);
        return (SubscriptionQueryResult)GSON.fromJson(response, SubscriptionQueryResult.class);
    }

    @Override
    public SubscriptionCancelResult cancelSubscription(SubscriptionCancelRequest request) throws WxPayException {
        String url = String.format("%s/v3/subscription-billing/schedule/%s/cancel", this.payService.getPayBaseUrl(), request.getSubscriptionId());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (SubscriptionCancelResult)GSON.fromJson(response, SubscriptionCancelResult.class);
    }

    @Override
    public SubscriptionInstantBillingResult instantBilling(SubscriptionInstantBillingRequest request) throws WxPayException {
        String url = String.format("%s/v3/subscription-billing/instant-billing", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (SubscriptionInstantBillingResult)GSON.fromJson(response, SubscriptionInstantBillingResult.class);
    }

    @Override
    public SubscriptionTransactionQueryResult queryTransactions(SubscriptionTransactionQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/subscription-billing/transactions", this.payService.getPayBaseUrl());
        StringBuilder queryString = new StringBuilder();
        if (request.getOpenid() != null) {
            queryString.append("openid=").append(request.getOpenid()).append("&");
        }
        if (request.getBeginTime() != null) {
            queryString.append("begin_time=").append(request.getBeginTime()).append("&");
        }
        if (request.getEndTime() != null) {
            queryString.append("end_time=").append(request.getEndTime()).append("&");
        }
        if (request.getLimit() != null) {
            queryString.append("limit=").append(request.getLimit()).append("&");
        }
        if (request.getOffset() != null) {
            queryString.append("offset=").append(request.getOffset()).append("&");
        }
        if (queryString.length() > 0) {
            queryString.setLength(queryString.length() - 1);
            url = url + "?" + queryString.toString();
        }
        String response = this.payService.getV3(url);
        return (SubscriptionTransactionQueryResult)GSON.fromJson(response, SubscriptionTransactionQueryResult.class);
    }

    public SubscriptionBillingServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

