/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.request.WxDepositConsumeRequest;
import com.github.binarywang.wxpay.bean.request.WxDepositOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxDepositRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxDepositUnfreezeRequest;
import com.github.binarywang.wxpay.bean.request.WxDepositUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxDepositConsumeResult;
import com.github.binarywang.wxpay.bean.result.WxDepositOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxDepositRefundResult;
import com.github.binarywang.wxpay.bean.result.WxDepositUnfreezeResult;
import com.github.binarywang.wxpay.bean.result.WxDepositUnifiedOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxDepositService;
import com.github.binarywang.wxpay.service.WxPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxDepositServiceImpl
implements WxDepositService {
    private static final Logger log = LoggerFactory.getLogger(WxDepositServiceImpl.class);
    private final WxPayService payService;

    @Override
    public WxDepositUnifiedOrderResult unifiedOrder(WxDepositUnifiedOrderRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/depositpay";
        String responseContent = this.payService.post(url, request.toXML(), false);
        WxDepositUnifiedOrderResult result = BaseWxPayResult.fromXML(responseContent, WxDepositUnifiedOrderResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public WxDepositOrderQueryResult queryOrder(WxDepositOrderQueryRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/depositorderquery";
        String responseContent = this.payService.post(url, request.toXML(), false);
        WxDepositOrderQueryResult result = BaseWxPayResult.fromXML(responseContent, WxDepositOrderQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public WxDepositConsumeResult consume(WxDepositConsumeRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/depositconsume";
        String responseContent = this.payService.post(url, request.toXML(), false);
        WxDepositConsumeResult result = BaseWxPayResult.fromXML(responseContent, WxDepositConsumeResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public WxDepositUnfreezeResult unfreeze(WxDepositUnfreezeRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/depositreverse";
        String responseContent = this.payService.post(url, request.toXML(), false);
        WxDepositUnfreezeResult result = BaseWxPayResult.fromXML(responseContent, WxDepositUnfreezeResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public WxDepositRefundResult refund(WxDepositRefundRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/depositrefund";
        String responseContent = this.payService.post(url, request.toXML(), true);
        WxDepositRefundResult result = BaseWxPayResult.fromXML(responseContent, WxDepositRefundResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    public WxDepositServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

