/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.WxPayApiData;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.BaseWxPayServiceImpl;
import com.github.binarywang.wxpay.v3.WxPayV3DownloadHttpGet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import me.chanjar.weixin.common.util.http.apache.ByteArrayResponseHandler;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayServiceHttpComponentsImpl
extends BaseWxPayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceHttpComponentsImpl.class);
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String WECHAT_PAY_SERIAL = "Wechatpay-Serial";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] postForBytes(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(useKey);
            HttpPost httpPost = this.createHttpPost(url, requestStr);
            try (CloseableHttpClient httpClient = httpClientBuilder.build();){
                byte[] bytes = (byte[])httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)ByteArrayResponseHandler.INSTANCE);
                String responseData = Base64.getEncoder().encodeToString(bytes);
                this.logRequestAndResponse(url, requestStr, responseData);
                wxApiData.set(new WxPayApiData(url, requestStr, responseData, null));
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (Exception e) {
            this.logError(url, requestStr, e);
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String post(String url, String requestStr, boolean useKey) throws WxPayException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String post(String url, String requestStr, boolean useKey, String mimeType) throws WxPayException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String postV3(String url, String requestStr) throws WxPayException {
        HttpPost httpPost = this.createHttpPost(url, requestStr);
        this.configureRequest((HttpRequestBase)httpPost);
        return this.requestV3(url, requestStr, (HttpRequestBase)httpPost);
    }

    private String requestV3(String url, String requestStr, HttpRequestBase httpRequestBase) throws WxPayException {
        CloseableHttpClient httpClient = this.createApiV3HttpClient();
        try {
            String responseString;
            Throwable throwable;
            CloseableHttpResponse response;
            block19: {
                String string;
                block20: {
                    block21: {
                        response = httpClient.execute((HttpUriRequest)httpRequestBase);
                        throwable = null;
                        int statusCode = response.getStatusLine().getStatusCode();
                        responseString = null;
                        if (response.getEntity() != null) {
                            responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                        }
                        if (200 != statusCode && 204 != statusCode) break block19;
                        this.logRequestAndResponse(url, requestStr, responseString);
                        string = responseString;
                        if (response == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        JsonObject jsonObject = GsonParser.parse((String)responseString);
                        throw this.convertException(jsonObject);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Exception e) {
                this.logError(url, requestStr, e);
                throw e instanceof WxPayException ? (WxPayException)e : new WxPayException(e.getMessage(), e);
            }
        }
        finally {
            httpRequestBase.releaseConnection();
        }
    }

    @Override
    public String patchV3(String url, String requestStr) throws WxPayException {
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setEntity((HttpEntity)WxPayServiceHttpComponentsImpl.createEntry(requestStr));
        return this.requestV3(url, requestStr, (HttpRequestBase)httpPatch);
    }

    @Override
    public String postV3WithWechatpaySerial(String url, String requestStr) throws WxPayException {
        HttpPost httpPost = this.createHttpPost(url, requestStr);
        this.configureRequest((HttpRequestBase)httpPost);
        CloseableHttpClient httpClient = this.createApiV3HttpClient();
        try {
            String responseString;
            Throwable throwable;
            CloseableHttpResponse response;
            block19: {
                String string;
                block20: {
                    block21: {
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        throwable = null;
                        int statusCode = response.getStatusLine().getStatusCode();
                        responseString = "{}";
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            responseString = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        }
                        if (200 != statusCode && 204 != statusCode) break block19;
                        this.logRequestAndResponse(url, requestStr, responseString);
                        string = responseString;
                        if (response == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        JsonObject jsonObject = GsonParser.parse((String)responseString);
                        throw this.convertException(jsonObject);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Exception e) {
                this.logError(url, requestStr, e);
                throw e instanceof WxPayException ? (WxPayException)e : new WxPayException(e.getMessage(), e);
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    @Override
    public String postV3(String url, HttpPost httpPost) throws WxPayException {
        return this.requestV3(url, (HttpRequestBase)httpPost);
    }

    @Override
    public String requestV3(String url, HttpRequestBase httpRequest) throws WxPayException {
        this.configureRequest(httpRequest);
        CloseableHttpClient httpClient = this.createApiV3HttpClient();
        try {
            String responseString;
            Throwable throwable;
            CloseableHttpResponse response;
            block19: {
                String string;
                block20: {
                    block21: {
                        response = httpClient.execute((HttpUriRequest)httpRequest);
                        throwable = null;
                        int statusCode = response.getStatusLine().getStatusCode();
                        responseString = null;
                        if (response.getEntity() != null) {
                            responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                        }
                        if (200 != statusCode && 204 != statusCode) break block19;
                        log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", (Object)url, (Object)responseString);
                        string = responseString;
                        if (response == null) break block20;
                        if (throwable == null) break block21;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        JsonObject jsonObject = GsonParser.parse((String)responseString);
                        throw this.convertException(jsonObject);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Exception e) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", (Object)url, (Object)e.getMessage());
                throw e instanceof WxPayException ? (WxPayException)e : new WxPayException(e.getMessage(), e);
            }
        }
        finally {
            httpRequest.releaseConnection();
        }
    }

    @Override
    public String getV3(String url) throws WxPayException {
        if (this.getConfig().isStrictlyNeedWechatPaySerial()) {
            return this.getV3WithWechatPaySerial(url);
        }
        HttpGet httpGet = new HttpGet(url);
        return this.requestV3(url, (HttpRequestBase)httpGet);
    }

    @Override
    public String getV3WithWechatPaySerial(String url) throws WxPayException {
        HttpGet httpGet = new HttpGet(url);
        return this.requestV3(url, (HttpRequestBase)httpGet);
    }

    @Override
    public InputStream downloadV3(String url) throws WxPayException {
        WxPayV3DownloadHttpGet httpGet = new WxPayV3DownloadHttpGet(url);
        this.configureRequest((HttpRequestBase)httpGet);
        CloseableHttpClient httpClient = this.createApiV3HttpClient();
        try {
            Throwable throwable;
            CloseableHttpResponse response;
            block18: {
                InputStream inputStream;
                block19: {
                    block20: {
                        boolean isJsonContentType;
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        throwable = null;
                        int statusCode = response.getStatusLine().getStatusCode();
                        Header contentType = response.getFirstHeader(CONTENT_TYPE);
                        boolean bl = isJsonContentType = Objects.nonNull(contentType) && ContentType.APPLICATION_JSON.getMimeType().equals(ContentType.parse((String)String.valueOf(contentType.getValue())).getMimeType());
                        if (200 != statusCode && 204 != statusCode || isJsonContentType) break block18;
                        log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n", (Object)url);
                        inputStream = response.getEntity().getContent();
                        if (response == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    response.close();
                }
                return inputStream;
            }
            try {
                try {
                    try {
                        String responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                        JsonObject jsonObject = GsonParser.parse((String)responseString);
                        throw this.convertException(jsonObject);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Exception e) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", (Object)url, (Object)e.getMessage());
                throw e instanceof WxPayException ? (WxPayException)e : new WxPayException(e.getMessage(), e);
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    @Override
    public String putV3(String url, String requestStr) throws WxPayException {
        HttpPut httpPut = new HttpPut(url);
        StringEntity entity = WxPayServiceHttpComponentsImpl.createEntry(requestStr);
        httpPut.setEntity((HttpEntity)entity);
        return this.requestV3(url, (HttpRequestBase)httpPut);
    }

    @Override
    public String deleteV3(String url) throws WxPayException {
        HttpDelete httpDelete = new HttpDelete(url);
        return this.requestV3(url, (HttpRequestBase)httpDelete);
    }

    private void configureRequest(HttpRequestBase request) {
        String serialNumber = this.getWechatPaySerial(this.getConfig());
        String method = request.getMethod();
        request.addHeader(ACCEPT, APPLICATION_JSON);
        if (!method.equals("POST")) {
            request.addHeader(CONTENT_TYPE, APPLICATION_JSON);
        }
        request.addHeader(WECHAT_PAY_SERIAL, serialNumber);
        request.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.getConfig().getHttpConnectionTimeout()).setConnectTimeout(this.getConfig().getHttpConnectionTimeout()).setSocketTimeout(this.getConfig().getHttpTimeout()).build());
    }

    private CloseableHttpClient createApiV3HttpClient() throws WxPayException {
        CloseableHttpClient apiV3HttpClient = this.getConfig().getApiV3HttpClient();
        if (null == apiV3HttpClient) {
            return this.getConfig().initApiV3HttpClient();
        }
        return apiV3HttpClient;
    }

    private static StringEntity createEntry(String requestStr) {
        return new StringEntity(requestStr, ContentType.create((String)APPLICATION_JSON, (Charset)StandardCharsets.UTF_8));
    }

    private static StringEntity createEntry(String requestStr, String mimeType) {
        return new StringEntity(requestStr, ContentType.create((String)mimeType, (Charset)StandardCharsets.UTF_8));
    }

    private HttpClientBuilder createHttpClientBuilder(boolean useKey) throws WxPayException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (useKey) {
            this.initSSLContext(httpClientBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue()), (Credentials)new UsernamePasswordCredentials(this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider).setProxy(new HttpHost(this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue()));
        }
        Optional.ofNullable(this.getConfig().getHttpClientBuilderCustomizer()).ifPresent(e -> e.customize(httpClientBuilder));
        return httpClientBuilder;
    }

    private HttpPost createHttpPost(String url, String requestStr) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)WxPayServiceHttpComponentsImpl.createEntry(requestStr));
        httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.getConfig().getHttpConnectionTimeout()).setConnectTimeout(this.getConfig().getHttpConnectionTimeout()).setSocketTimeout(this.getConfig().getHttpTimeout()).build());
        return httpPost;
    }

    private HttpPost createHttpPost(String url, String requestStr, String mimeType) throws WxPayException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)WxPayServiceHttpComponentsImpl.createEntry(requestStr, mimeType));
        httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.getConfig().getHttpConnectionTimeout()).setConnectTimeout(this.getConfig().getHttpConnectionTimeout()).setSocketTimeout(this.getConfig().getHttpTimeout()).build());
        return httpPost;
    }

    private void initSSLContext(HttpClientBuilder httpClientBuilder) throws WxPayException {
        SSLContext sslContext = this.getConfig().getSslContext();
        if (null == sslContext) {
            sslContext = this.getConfig().initSSLContext();
        }
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier()));
    }

    private WxPayException convertException(JsonObject jsonObject) {
        JsonElement codeElement = jsonObject.get("code");
        String code = codeElement == null ? null : codeElement.getAsString();
        String message = jsonObject.get("message").getAsString();
        WxPayException wxPayException = new WxPayException(message);
        wxPayException.setErrCode(code);
        wxPayException.setErrCodeDes(message);
        return wxPayException;
    }

    private String getWechatPaySerial(WxPayConfig wxPayConfig) {
        if (StringUtils.isNotBlank((CharSequence)wxPayConfig.getPublicKeyId())) {
            return wxPayConfig.getPublicKeyId();
        }
        return wxPayConfig.getVerifier().getValidCertificate().getSerialNumber().toString(16).toUpperCase();
    }

    private void logRequestAndResponse(String url, String requestStr, String responseStr) {
        log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseStr});
    }

    private void logError(String url, String requestStr, Exception e) {
        log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
    }
}

