/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Random;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class SignUtils {
    private static volatile Random random;

    public static String sign(String string, PrivateKey privateKey) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(privateKey);
            sign.update(string.getBytes());
            return Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new WxRuntimeException("\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u79c1\u94a5", (Throwable)e);
        }
    }

    public static String genRandomStr() {
        return SignUtils.genRandomStr(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Random getRandom() {
        if (random != null) return random;
        Class<SignUtils> clazz = SignUtils.class;
        synchronized (SignUtils.class) {
            if (random != null) return random;
            random = new Random();
            // ** MonitorExit[var0] (shouldn't be in output)
            return random;
        }
    }

    public static String genRandomStr(int length) {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random r = SignUtils.getRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = r.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
}

