/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.channel.configuration.services;

import com.binarywang.solon.wxjava.channel.enums.HttpClientType;
import com.binarywang.solon.wxjava.channel.properties.WxChannelMultiProperties;
import com.binarywang.solon.wxjava.channel.properties.WxChannelSingleProperties;
import com.binarywang.solon.wxjava.channel.service.WxChannelMultiServices;
import com.binarywang.solon.wxjava.channel.service.WxChannelMultiServicesImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.chanjar.weixin.channel.api.WxChannelService;
import me.chanjar.weixin.channel.api.impl.WxChannelServiceHttpClientImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelServiceHttpComponentsImpl;
import me.chanjar.weixin.channel.api.impl.WxChannelServiceImpl;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWxChannelConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxChannelConfiguration.class);

    protected WxChannelMultiServices wxChannelMultiServices(WxChannelMultiProperties wxChannelMultiProperties) {
        boolean multi;
        Map<String, WxChannelSingleProperties> appsMap = wxChannelMultiProperties.getApps();
        if (appsMap == null || appsMap.isEmpty()) {
            log.warn("\u5fae\u4fe1\u89c6\u9891\u53f7\u5e94\u7528\u53c2\u6570\u672a\u914d\u7f6e\uff0c\u901a\u8fc7 WxChannelMultiServices#getWxChannelService(\"tenantId\")\u83b7\u53d6\u5b9e\u4f8b\u5c06\u8fd4\u56de\u7a7a");
            return new WxChannelMultiServicesImpl();
        }
        Collection<WxChannelSingleProperties> apps = appsMap.values();
        if (apps.size() > 1 && (multi = apps.stream().collect(Collectors.groupingBy(c -> c.getAppId() == null ? Integer.valueOf(0) : c.getAppId(), Collectors.counting())).entrySet().stream().anyMatch(e -> (Long)e.getValue() > 1L))) {
            throw new RuntimeException("\u8bf7\u786e\u4fdd\u5fae\u4fe1\u89c6\u9891\u53f7\u914d\u7f6e appId \u7684\u552f\u4e00\u6027");
        }
        WxChannelMultiServicesImpl services = new WxChannelMultiServicesImpl();
        Set<Map.Entry<String, WxChannelSingleProperties>> entries = appsMap.entrySet();
        for (Map.Entry<String, WxChannelSingleProperties> entry : entries) {
            String tenantId = entry.getKey();
            WxChannelSingleProperties wxChannelSingleProperties = entry.getValue();
            WxChannelDefaultConfigImpl storage = this.wxChannelConfigStorage(wxChannelMultiProperties);
            this.configApp(storage, wxChannelSingleProperties);
            this.configHttp(storage, wxChannelMultiProperties.getConfigStorage());
            WxChannelService wxChannelService = this.wxChannelService((WxChannelConfig)storage, wxChannelMultiProperties);
            services.addWxChannelService(tenantId, wxChannelService);
        }
        return services;
    }

    protected abstract WxChannelDefaultConfigImpl wxChannelConfigStorage(WxChannelMultiProperties var1);

    public WxChannelService wxChannelService(WxChannelConfig wxChannelConfig, WxChannelMultiProperties wxChannelMultiProperties) {
        int retrySleepMillis;
        WxChannelServiceHttpClientImpl wxChannelService;
        WxChannelMultiProperties.ConfigStorage storage = wxChannelMultiProperties.getConfigStorage();
        HttpClientType httpClientType = storage.getHttpClientType();
        switch (httpClientType) {
            case HTTP_CLIENT: {
                wxChannelService = new WxChannelServiceHttpClientImpl();
                break;
            }
            case HTTP_COMPONENTS: {
                wxChannelService = new WxChannelServiceHttpComponentsImpl();
                break;
            }
            default: {
                wxChannelService = new WxChannelServiceImpl();
            }
        }
        wxChannelService.setConfig(wxChannelConfig);
        int maxRetryTimes = storage.getMaxRetryTimes();
        if (maxRetryTimes < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        wxChannelService.setRetrySleepMillis(retrySleepMillis);
        wxChannelService.setMaxRetryTimes(maxRetryTimes);
        return wxChannelService;
    }

    private void configApp(WxChannelDefaultConfigImpl config, WxChannelSingleProperties wxChannelSingleProperties) {
        String appId = wxChannelSingleProperties.getAppId();
        String appSecret = wxChannelSingleProperties.getSecret();
        String token = wxChannelSingleProperties.getToken();
        String aesKey = wxChannelSingleProperties.getAesKey();
        boolean useStableAccessToken = wxChannelSingleProperties.isUseStableAccessToken();
        config.setAppid(appId);
        config.setSecret(appSecret);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            config.setToken(token);
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey)) {
            config.setAesKey(aesKey);
        }
        config.setStableAccessToken(useStableAccessToken);
    }

    private void configHttp(WxChannelDefaultConfigImpl config, WxChannelMultiProperties.ConfigStorage storage) {
        String httpProxyHost = storage.getHttpProxyHost();
        Integer httpProxyPort = storage.getHttpProxyPort();
        String httpProxyUsername = storage.getHttpProxyUsername();
        String httpProxyPassword = storage.getHttpProxyPassword();
        if (StringUtils.isNotBlank((CharSequence)httpProxyHost)) {
            config.setHttpProxyHost(httpProxyHost);
            if (httpProxyPort != null) {
                config.setHttpProxyPort(httpProxyPort.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyUsername)) {
                config.setHttpProxyUsername(httpProxyUsername);
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyPassword)) {
                config.setHttpProxyPassword(httpProxyPassword);
            }
        }
    }
}

