/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.channel.configuration.services;

import com.binarywang.solon.wxjava.channel.configuration.services.AbstractWxChannelConfiguration;
import com.binarywang.solon.wxjava.channel.properties.WxChannelMultiProperties;
import com.binarywang.solon.wxjava.channel.properties.WxChannelMultiRedisProperties;
import com.binarywang.solon.wxjava.channel.service.WxChannelMultiServices;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.channel.config.impl.WxChannelRedisConfigImpl;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@Condition(onProperty="${wx.channel.configStorage.type} = jedis", onClass=JedisPool.class)
public class WxChannelInJedisConfiguration
extends AbstractWxChannelConfiguration {
    private final WxChannelMultiProperties wxChannelMultiProperties;
    private final AppContext applicationContext;

    @Bean
    public WxChannelMultiServices wxChannelMultiServices() {
        return this.wxChannelMultiServices(this.wxChannelMultiProperties);
    }

    @Override
    protected WxChannelDefaultConfigImpl wxChannelConfigStorage(WxChannelMultiProperties wxChannelMultiProperties) {
        return this.configRedis(wxChannelMultiProperties);
    }

    private WxChannelDefaultConfigImpl configRedis(WxChannelMultiProperties wxChannelMultiProperties) {
        WxChannelMultiRedisProperties wxChannelMultiRedisProperties = wxChannelMultiProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = wxChannelMultiRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxChannelMultiRedisProperties.getHost()) ? this.getJedisPool(wxChannelMultiProperties) : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        return new WxChannelRedisConfigImpl((WxRedisOps)new JedisWxRedisOps((Pool)jedisPool), wxChannelMultiProperties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool(WxChannelMultiProperties wxChannelMultiProperties) {
        WxChannelMultiProperties.ConfigStorage storage = wxChannelMultiProperties.getConfigStorage();
        WxChannelMultiRedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxChannelInJedisConfiguration(WxChannelMultiProperties wxChannelMultiProperties, AppContext applicationContext) {
        this.wxChannelMultiProperties = wxChannelMultiProperties;
        this.applicationContext = applicationContext;
    }
}

