/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.channel.configuration.services;

import com.binarywang.solon.wxjava.channel.configuration.services.AbstractWxChannelConfiguration;
import com.binarywang.solon.wxjava.channel.properties.WxChannelMultiProperties;
import com.binarywang.solon.wxjava.channel.properties.WxChannelMultiRedisProperties;
import com.binarywang.solon.wxjava.channel.service.WxChannelMultiServices;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.channel.config.impl.WxChannelRedissonConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.channel.configStorage.type} = redisson", onClass=Redisson.class)
public class WxChannelInRedissonConfiguration
extends AbstractWxChannelConfiguration {
    private final WxChannelMultiProperties wxChannelMultiProperties;
    private final AppContext applicationContext;

    @Bean
    public WxChannelMultiServices wxChannelMultiServices() {
        return this.wxChannelMultiServices(this.wxChannelMultiProperties);
    }

    @Override
    protected WxChannelDefaultConfigImpl wxChannelConfigStorage(WxChannelMultiProperties wxChannelMultiProperties) {
        return this.configRedisson(wxChannelMultiProperties);
    }

    private WxChannelDefaultConfigImpl configRedisson(WxChannelMultiProperties wxChannelMultiProperties) {
        WxChannelMultiRedisProperties redisProperties = wxChannelMultiProperties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient(wxChannelMultiProperties) : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxChannelRedissonConfigImpl(redissonClient, wxChannelMultiProperties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient(WxChannelMultiProperties wxChannelMultiProperties) {
        WxChannelMultiProperties.ConfigStorage storage = wxChannelMultiProperties.getConfigStorage();
        WxChannelMultiRedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxChannelInRedissonConfiguration(WxChannelMultiProperties wxChannelMultiProperties, AppContext applicationContext) {
        this.wxChannelMultiProperties = wxChannelMultiProperties;
        this.applicationContext = applicationContext;
    }
}

