/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.channel.config.storage;

import com.binarywang.solon.wxjava.channel.config.storage.AbstractWxChannelConfigStorageConfiguration;
import com.binarywang.solon.wxjava.channel.properties.RedisProperties;
import com.binarywang.solon.wxjava.channel.properties.WxChannelProperties;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.channel.config.impl.WxChannelRedisConfigImpl;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@Condition(onProperty="${wx.channel.configStorage.type} = jedis", onClass=JedisPool.class)
public class WxChannelInJedisConfigStorageConfiguration
extends AbstractWxChannelConfigStorageConfiguration {
    private final WxChannelProperties properties;
    private final AppContext applicationContext;

    @Bean
    @Condition(onMissingBean=WxChannelConfig.class)
    public WxChannelConfig wxChannelConfig() {
        WxChannelRedisConfigImpl config = this.getWxChannelRedisConfig();
        return this.config((WxChannelDefaultConfigImpl)config, this.properties);
    }

    private WxChannelRedisConfigImpl getWxChannelRedisConfig() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        JedisPool jedisPool = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        return new WxChannelRedisConfigImpl((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool() {
        WxChannelProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxChannelInJedisConfigStorageConfiguration(WxChannelProperties properties, AppContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

