/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.cp_multi.configuration.services;

import com.binarywang.solon.wxjava.cp_multi.properties.WxCpMultiProperties;
import com.binarywang.solon.wxjava.cp_multi.properties.WxCpSingleProperties;
import com.binarywang.solon.wxjava.cp_multi.service.WxCpMultiServices;
import com.binarywang.solon.wxjava.cp_multi.service.WxCpMultiServicesImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceApacheHttpClientImpl;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpServiceJoddHttpImpl;
import me.chanjar.weixin.cp.api.impl.WxCpServiceOkHttpImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWxCpConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxCpConfiguration.class);

    protected WxCpMultiServices wxCpMultiServices(WxCpMultiProperties wxCpMultiProperties) {
        Set<Map.Entry<String, Object>> entries;
        Map<String, WxCpSingleProperties> corps = wxCpMultiProperties.getCorps();
        if (corps == null || corps.isEmpty()) {
            log.warn("\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u53c2\u6570\u672a\u914d\u7f6e\uff0c\u901a\u8fc7 WxCpMultiServices#getWxCpService(\"tenantId\")\u83b7\u53d6\u5b9e\u4f8b\u5c06\u8fd4\u56de\u7a7a");
            return new WxCpMultiServicesImpl();
        }
        Collection<WxCpSingleProperties> corpList = corps.values();
        if (corpList.size() > 1) {
            Map<String, List<WxCpSingleProperties>> corpsMap = corpList.stream().collect(Collectors.groupingBy(WxCpSingleProperties::getCorpId));
            entries = corpsMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String corpId = entry.getKey();
                boolean multi = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(c -> c.getAgentId() == null ? 0 : c.getAgentId(), Collectors.counting())).entrySet().stream().anyMatch(e -> (Long)e.getValue() > 1L);
                if (!multi) continue;
                throw new RuntimeException("\u8bf7\u786e\u4fdd\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u552f\u4e00\u6027[" + corpId + "]");
            }
        }
        WxCpMultiServicesImpl services = new WxCpMultiServicesImpl();
        entries = corps.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String tenantId = entry.getKey();
            WxCpSingleProperties wxCpSingleProperties = (WxCpSingleProperties)entry.getValue();
            WxCpDefaultConfigImpl storage = this.wxCpConfigStorage(wxCpMultiProperties);
            this.configCorp(storage, wxCpSingleProperties);
            this.configHttp(storage, wxCpMultiProperties.getConfigStorage());
            WxCpService wxCpService = this.wxCpService((WxCpConfigStorage)storage, wxCpMultiProperties.getConfigStorage());
            services.addWxCpService(tenantId, wxCpService);
        }
        return services;
    }

    protected abstract WxCpDefaultConfigImpl wxCpConfigStorage(WxCpMultiProperties var1);

    private WxCpService wxCpService(WxCpConfigStorage wxCpConfigStorage, WxCpMultiProperties.ConfigStorage storage) {
        int retrySleepMillis;
        WxCpServiceOkHttpImpl wxCpService;
        WxCpMultiProperties.HttpClientType httpClientType = storage.getHttpClientType();
        switch (httpClientType) {
            case OK_HTTP: {
                wxCpService = new WxCpServiceOkHttpImpl();
                break;
            }
            case JODD_HTTP: {
                wxCpService = new WxCpServiceJoddHttpImpl();
                break;
            }
            case HTTP_CLIENT: {
                wxCpService = new WxCpServiceApacheHttpClientImpl();
                break;
            }
            default: {
                wxCpService = new WxCpServiceImpl();
            }
        }
        wxCpService.setWxCpConfigStorage(wxCpConfigStorage);
        int maxRetryTimes = storage.getMaxRetryTimes();
        if (maxRetryTimes < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        wxCpService.setRetrySleepMillis(retrySleepMillis);
        wxCpService.setMaxRetryTimes(maxRetryTimes);
        return wxCpService;
    }

    private void configCorp(WxCpDefaultConfigImpl config, WxCpSingleProperties wxCpSingleProperties) {
        String corpId = wxCpSingleProperties.getCorpId();
        String corpSecret = wxCpSingleProperties.getCorpSecret();
        Integer agentId = wxCpSingleProperties.getAgentId();
        String token = wxCpSingleProperties.getToken();
        String aesKey = wxCpSingleProperties.getAesKey();
        String msgAuditPriKey = wxCpSingleProperties.getMsgAuditPriKey();
        String msgAuditLibPath = wxCpSingleProperties.getMsgAuditLibPath();
        config.setCorpId(corpId);
        config.setCorpSecret(corpSecret);
        config.setAgentId(agentId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            config.setToken(token);
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey)) {
            config.setAesKey(aesKey);
        }
        if (StringUtils.isNotBlank((CharSequence)msgAuditPriKey)) {
            config.setMsgAuditPriKey(msgAuditPriKey);
        }
        if (StringUtils.isNotBlank((CharSequence)msgAuditLibPath)) {
            config.setMsgAuditLibPath(msgAuditLibPath);
        }
    }

    private void configHttp(WxCpDefaultConfigImpl config, WxCpMultiProperties.ConfigStorage storage) {
        String httpProxyHost = storage.getHttpProxyHost();
        Integer httpProxyPort = storage.getHttpProxyPort();
        String httpProxyUsername = storage.getHttpProxyUsername();
        String httpProxyPassword = storage.getHttpProxyPassword();
        if (StringUtils.isNotBlank((CharSequence)httpProxyHost)) {
            config.setHttpProxyHost(httpProxyHost);
            if (httpProxyPort != null) {
                config.setHttpProxyPort(httpProxyPort.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyUsername)) {
                config.setHttpProxyUsername(httpProxyUsername);
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyPassword)) {
                config.setHttpProxyPassword(httpProxyPassword);
            }
        }
    }
}

