/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.cp.storage;

import com.binarywang.solon.wxjava.cp.properties.WxCpProperties;
import com.binarywang.solon.wxjava.cp.properties.WxCpRedisProperties;
import com.binarywang.solon.wxjava.cp.storage.AbstractWxCpConfigStorageConfiguration;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpJedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@Condition(onProperty="${wx.cp.configStorage.type} = jedis", onClass=JedisPool.class)
public class WxCpInJedisConfigStorageConfiguration
extends AbstractWxCpConfigStorageConfiguration {
    private final WxCpProperties wxCpProperties;
    private final AppContext applicationContext;

    @Bean
    @Condition(onMissingBean=WxCpConfigStorage.class)
    public WxCpConfigStorage wxCpConfigStorage() {
        WxCpJedisConfigImpl config = this.getConfigStorage();
        return this.config((WxCpDefaultConfigImpl)config, this.wxCpProperties);
    }

    private WxCpJedisConfigImpl getConfigStorage() {
        WxCpRedisProperties wxCpRedisProperties = this.wxCpProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = wxCpRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxCpRedisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        return new WxCpJedisConfigImpl((Pool)jedisPool, this.wxCpProperties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool() {
        WxCpProperties.ConfigStorage storage = this.wxCpProperties.getConfigStorage();
        WxCpRedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxCpInJedisConfigStorageConfiguration(WxCpProperties wxCpProperties, AppContext applicationContext) {
        this.wxCpProperties = wxCpProperties;
        this.applicationContext = applicationContext;
    }
}

