/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.cp.storage;

import com.binarywang.solon.wxjava.cp.properties.WxCpProperties;
import com.binarywang.solon.wxjava.cp.properties.WxCpRedisProperties;
import com.binarywang.solon.wxjava.cp.storage.AbstractWxCpConfigStorageConfiguration;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpRedissonConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.cp.configStorage.type} = redisson", onClass=Redisson.class)
public class WxCpInRedissonConfigStorageConfiguration
extends AbstractWxCpConfigStorageConfiguration {
    private final WxCpProperties wxCpProperties;
    private final AppContext applicationContext;

    @Bean
    @Condition(onMissingBean=WxCpConfigStorage.class)
    public WxCpConfigStorage wxCpConfigStorage() {
        WxCpRedissonConfigImpl config = this.getConfigStorage();
        return this.config((WxCpDefaultConfigImpl)config, this.wxCpProperties);
    }

    private WxCpRedissonConfigImpl getConfigStorage() {
        WxCpRedisProperties redisProperties = this.wxCpProperties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxCpRedissonConfigImpl(redissonClient, this.wxCpProperties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxCpProperties.ConfigStorage storage = this.wxCpProperties.getConfigStorage();
        WxCpRedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxCpInRedissonConfigStorageConfiguration(WxCpProperties wxCpProperties, AppContext applicationContext) {
        this.wxCpProperties = wxCpProperties;
        this.applicationContext = applicationContext;
    }
}

