/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.mp_multi.configuration.services;

import com.binarywang.solon.wxjava.mp_multi.properties.WxMpMultiProperties;
import com.binarywang.solon.wxjava.mp_multi.properties.WxMpSingleProperties;
import com.binarywang.solon.wxjava.mp_multi.service.WxMpMultiServices;
import com.binarywang.solon.wxjava.mp_multi.service.WxMpMultiServicesImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceHttpClientImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceJoddHttpImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceOkHttpImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.WxMpHostConfig;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWxMpConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxMpConfiguration.class);

    protected WxMpMultiServices wxMpMultiServices(WxMpMultiProperties wxCpMultiProperties) {
        boolean multi;
        Map<String, WxMpSingleProperties> appsMap = wxCpMultiProperties.getApps();
        if (appsMap == null || appsMap.isEmpty()) {
            log.warn("\u5fae\u4fe1\u516c\u4f17\u53f7\u5e94\u7528\u53c2\u6570\u672a\u914d\u7f6e\uff0c\u901a\u8fc7 WxMpMultiServices#getWxMpService(\"tenantId\")\u83b7\u53d6\u5b9e\u4f8b\u5c06\u8fd4\u56de\u7a7a");
            return new WxMpMultiServicesImpl();
        }
        Collection<WxMpSingleProperties> apps = appsMap.values();
        if (apps.size() > 1 && (multi = apps.stream().collect(Collectors.groupingBy(c -> c.getAppId() == null ? Integer.valueOf(0) : c.getAppId(), Collectors.counting())).entrySet().stream().anyMatch(e -> (Long)e.getValue() > 1L))) {
            throw new RuntimeException("\u8bf7\u786e\u4fdd\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e appId \u7684\u552f\u4e00\u6027");
        }
        WxMpMultiServicesImpl services = new WxMpMultiServicesImpl();
        Set<Map.Entry<String, WxMpSingleProperties>> entries = appsMap.entrySet();
        for (Map.Entry<String, WxMpSingleProperties> entry : entries) {
            String tenantId = entry.getKey();
            WxMpSingleProperties wxMpSingleProperties = entry.getValue();
            WxMpDefaultConfigImpl storage = this.wxMpConfigStorage(wxCpMultiProperties);
            this.configApp(storage, wxMpSingleProperties);
            this.configHttp(storage, wxCpMultiProperties.getConfigStorage());
            this.configHost(storage, wxCpMultiProperties.getHosts());
            WxMpService wxCpService = this.wxMpService((WxMpConfigStorage)storage, wxCpMultiProperties);
            services.addWxMpService(tenantId, wxCpService);
        }
        return services;
    }

    protected abstract WxMpDefaultConfigImpl wxMpConfigStorage(WxMpMultiProperties var1);

    public WxMpService wxMpService(WxMpConfigStorage configStorage, WxMpMultiProperties wxMpMultiProperties) {
        int retrySleepMillis;
        WxMpServiceOkHttpImpl wxMpService;
        WxMpMultiProperties.ConfigStorage storage = wxMpMultiProperties.getConfigStorage();
        WxMpMultiProperties.HttpClientType httpClientType = storage.getHttpClientType();
        switch (httpClientType) {
            case OK_HTTP: {
                wxMpService = new WxMpServiceOkHttpImpl();
                break;
            }
            case JODD_HTTP: {
                wxMpService = new WxMpServiceJoddHttpImpl();
                break;
            }
            case HTTP_CLIENT: {
                wxMpService = new WxMpServiceHttpClientImpl();
                break;
            }
            default: {
                wxMpService = new WxMpServiceImpl();
            }
        }
        wxMpService.setWxMpConfigStorage(configStorage);
        int maxRetryTimes = storage.getMaxRetryTimes();
        if (maxRetryTimes < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        wxMpService.setRetrySleepMillis(retrySleepMillis);
        wxMpService.setMaxRetryTimes(maxRetryTimes);
        return wxMpService;
    }

    private void configApp(WxMpDefaultConfigImpl config, WxMpSingleProperties corpProperties) {
        String appId = corpProperties.getAppId();
        String appSecret = corpProperties.getAppSecret();
        String token = corpProperties.getToken();
        String aesKey = corpProperties.getAesKey();
        boolean useStableAccessToken = corpProperties.isUseStableAccessToken();
        config.setAppId(appId);
        config.setSecret(appSecret);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            config.setToken(token);
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey)) {
            config.setAesKey(aesKey);
        }
        config.setUseStableAccessToken(useStableAccessToken);
    }

    private void configHttp(WxMpDefaultConfigImpl config, WxMpMultiProperties.ConfigStorage storage) {
        String httpProxyHost = storage.getHttpProxyHost();
        Integer httpProxyPort = storage.getHttpProxyPort();
        String httpProxyUsername = storage.getHttpProxyUsername();
        String httpProxyPassword = storage.getHttpProxyPassword();
        if (StringUtils.isNotBlank((CharSequence)httpProxyHost)) {
            config.setHttpProxyHost(httpProxyHost);
            if (httpProxyPort != null) {
                config.setHttpProxyPort(httpProxyPort.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyUsername)) {
                config.setHttpProxyUsername(httpProxyUsername);
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyPassword)) {
                config.setHttpProxyPassword(httpProxyPassword);
            }
        }
    }

    private void configHost(WxMpDefaultConfigImpl config, WxMpMultiProperties.HostConfig hostConfig) {
        if (hostConfig != null) {
            String apiHost = hostConfig.getApiHost();
            String mpHost = hostConfig.getMpHost();
            String openHost = hostConfig.getOpenHost();
            WxMpHostConfig wxMpHostConfig = new WxMpHostConfig();
            wxMpHostConfig.setApiHost(StringUtils.isNotBlank((CharSequence)apiHost) ? apiHost : null);
            wxMpHostConfig.setMpHost(StringUtils.isNotBlank((CharSequence)mpHost) ? mpHost : null);
            wxMpHostConfig.setOpenHost(StringUtils.isNotBlank((CharSequence)openHost) ? openHost : null);
            config.setHostConfig(wxMpHostConfig);
        }
    }
}

