/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.mp_multi.configuration.services;

import com.binarywang.solon.wxjava.mp_multi.configuration.services.AbstractWxMpConfiguration;
import com.binarywang.solon.wxjava.mp_multi.properties.WxMpMultiProperties;
import com.binarywang.solon.wxjava.mp_multi.properties.WxMpMultiRedisProperties;
import com.binarywang.solon.wxjava.mp_multi.service.WxMpMultiServices;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@Condition(onProperty="${wx.mp.configStorage.type} = jedis", onClass=JedisPool.class)
public class WxMpInJedisConfiguration
extends AbstractWxMpConfiguration {
    private final WxMpMultiProperties wxCpMultiProperties;
    private final AppContext applicationContext;

    @Bean
    public WxMpMultiServices wxMpMultiServices() {
        return this.wxMpMultiServices(this.wxCpMultiProperties);
    }

    @Override
    protected WxMpDefaultConfigImpl wxMpConfigStorage(WxMpMultiProperties wxCpMultiProperties) {
        return this.configRedis(wxCpMultiProperties);
    }

    private WxMpDefaultConfigImpl configRedis(WxMpMultiProperties wxCpMultiProperties) {
        WxMpMultiRedisProperties wxCpMultiRedisProperties = wxCpMultiProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = wxCpMultiRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxCpMultiRedisProperties.getHost()) ? this.getJedisPool(wxCpMultiProperties) : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        return new WxMpRedisConfigImpl((WxRedisOps)new JedisWxRedisOps((Pool)jedisPool), wxCpMultiProperties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool(WxMpMultiProperties wxCpMultiProperties) {
        WxMpMultiProperties.ConfigStorage storage = wxCpMultiProperties.getConfigStorage();
        WxMpMultiRedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMpInJedisConfiguration(WxMpMultiProperties wxCpMultiProperties, AppContext applicationContext) {
        this.wxCpMultiProperties = wxCpMultiProperties;
        this.applicationContext = applicationContext;
    }
}

