/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp;

import com.binarywang.spring.starter.wxjava.mp.RedisProperties;
import com.binarywang.spring.starter.wxjava.mp.WxMpProperties;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInRedisConfigStorage;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class WxMpStorageAutoConfiguration {
    @Autowired
    private WxMpProperties properties;
    @Autowired(required=false)
    private JedisPool jedisPool;

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorage.class})
    public WxMpConfigStorage wxMpInMemoryConfigStorage() {
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxMpProperties.StorageType type = storage.getType();
        if (type == WxMpProperties.StorageType.redis) {
            return this.getWxMpInRedisConfigStorage();
        }
        return this.getWxMpInMemoryConfigStorage();
    }

    private WxMpInMemoryConfigStorage getWxMpInMemoryConfigStorage() {
        WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
        this.setWxMpInfo(config);
        return config;
    }

    private WxMpInRedisConfigStorage getWxMpInRedisConfigStorage() {
        JedisPool poolToUse = this.jedisPool;
        if (poolToUse == null) {
            poolToUse = this.getJedisPool();
        }
        WxMpInRedisConfigStorage config = new WxMpInRedisConfigStorage(poolToUse);
        this.setWxMpInfo((WxMpInMemoryConfigStorage)config);
        return config;
    }

    private void setWxMpInfo(WxMpInMemoryConfigStorage config) {
        config.setAppId(this.properties.getAppId());
        config.setSecret(this.properties.getSecret());
        config.setToken(this.properties.getToken());
        config.setAesKey(this.properties.getAesKey());
    }

    private JedisPool getJedisPool() {
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }
}

