/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config;

import com.binarywang.spring.starter.wxjava.open.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class WxOpenStorageAutoConfiguration {
    private final WxOpenProperties properties;
    @Autowired(required=false)
    private JedisPool jedisPool;
    @Value(value="${wx.open.config-storage.redis.host:}")
    private String redisHost;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxOpenProperties.StorageType type = storage.getType();
        if (type == WxOpenProperties.StorageType.redis) {
            return this.getWxOpenInRedisConfigStorage();
        }
        return this.getWxOpenInMemoryConfigStorage();
    }

    private WxOpenInMemoryConfigStorage getWxOpenInMemoryConfigStorage() {
        WxOpenInMemoryConfigStorage config = new WxOpenInMemoryConfigStorage();
        this.setWxOpenInfo((WxOpenConfigStorage)config);
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisConfigStorage() {
        JedisPool poolToUse = this.jedisPool;
        if (this.jedisPool == null || StringUtils.isNotEmpty((CharSequence)this.redisHost)) {
            poolToUse = this.getJedisPool();
        }
        WxOpenInRedisConfigStorage config = new WxOpenInRedisConfigStorage(poolToUse);
        this.setWxOpenInfo((WxOpenConfigStorage)config);
        return config;
    }

    private void setWxOpenInfo(WxOpenConfigStorage config) {
        config.setComponentAppId(this.properties.getAppId());
        config.setComponentAppSecret(this.properties.getSecret());
        config.setComponentToken(this.properties.getToken());
        config.setComponentAesKey(this.properties.getAesKey());
    }

    private JedisPool getJedisPool() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }

    public WxOpenStorageAutoConfiguration(WxOpenProperties properties) {
        this.properties = properties;
    }
}

