/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config;

import com.binarywang.spring.starter.wxjava.open.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedissonConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

@Configuration
public class WxOpenStorageAutoConfiguration {
    private final WxOpenProperties properties;
    @Autowired(required=false)
    private JedisPool jedisPool;
    @Autowired(required=false)
    private RedissonClient redissonClient;
    @Value(value="${wx.open.config-storage.redis.host:}")
    private String redisHost;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxOpenProperties.StorageType type = storage.getType();
        if (type == WxOpenProperties.StorageType.redis) {
            return this.getWxOpenInRedisConfigStorage();
        }
        if (type == WxOpenProperties.StorageType.jedis) {
            return this.getWxOpenInRedisConfigStorage();
        }
        if (type == WxOpenProperties.StorageType.redisson) {
            return this.getWxOpenInRedissonConfigStorage();
        }
        return this.getWxOpenInMemoryConfigStorage();
    }

    private WxOpenInMemoryConfigStorage getWxOpenInMemoryConfigStorage() {
        WxOpenInMemoryConfigStorage config = new WxOpenInMemoryConfigStorage();
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisConfigStorage() {
        JedisPool poolToUse = this.jedisPool;
        if (this.jedisPool == null || StringUtils.isNotEmpty((CharSequence)this.redisHost)) {
            poolToUse = this.getJedisPool();
        }
        WxOpenInRedisConfigStorage config = new WxOpenInRedisConfigStorage((Pool)poolToUse, this.properties.getConfigStorage().getKeyPrefix());
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        return config;
    }

    private WxOpenInRedissonConfigStorage getWxOpenInRedissonConfigStorage() {
        RedissonClient redissonClientToUse = this.redissonClient;
        if (this.redissonClient == null) {
            redissonClientToUse = this.getRedissonClient();
        }
        WxOpenInRedissonConfigStorage config = new WxOpenInRedissonConfigStorage(redissonClientToUse, this.properties.getConfigStorage().getKeyPrefix());
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        return config;
    }

    private JedisPool getJedisPool() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }

    private RedissonClient getRedissonClient() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxOpenStorageAutoConfiguration(WxOpenProperties properties) {
        this.properties = properties;
    }
}

