/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config;

import com.binarywang.spring.starter.wxjava.open.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.RedissonWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

@Configuration
public class WxOpenStorageAutoConfiguration {
    private final WxOpenProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxOpenProperties.StorageType type = storage.getType();
        Object config = type == WxOpenProperties.StorageType.redis || type == WxOpenProperties.StorageType.jedis ? this.getWxOpenInRedisConfigStorage() : (type == WxOpenProperties.StorageType.redisson ? this.getWxOpenInRedissonConfigStorage() : (type == WxOpenProperties.StorageType.redistemplate ? this.getWxOpenInRedisTemplateConfigStorage() : this.getWxOpenInMemoryConfigStorage()));
        WxOpenProperties.ConfigStorage configStorageProperties = this.properties.getConfigStorage();
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        return config;
    }

    private WxOpenInMemoryConfigStorage getWxOpenInMemoryConfigStorage() {
        WxOpenInMemoryConfigStorage config = new WxOpenInMemoryConfigStorage();
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisConfigStorage() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        JedisPool jedisPool = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        WxOpenInRedisConfigStorage config = new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedissonConfigStorage() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        RedissonWxRedisOps redisOps = new RedissonWxRedisOps(redissonClient);
        WxOpenInRedisConfigStorage config = new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        WxOpenInRedisConfigStorage config = new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
        return config;
    }

    private JedisPool getJedisPool() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }

    private RedissonClient getRedissonClient() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxOpenStorageAutoConfiguration(WxOpenProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

