/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="wx.open.config-storage", name={"type"}, matchIfMissing=true, havingValue="memory")
public class WxOpenInMemoryConfigStorageConfiguration {
    private final WxOpenProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenInMemoryConfigStorage config = new WxOpenInMemoryConfigStorage();
        WxOpenProperties.ConfigStorage configStorageProperties = this.properties.getConfigStorage();
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        return config;
    }

    public WxOpenInMemoryConfigStorageConfiguration(WxOpenProperties properties) {
        this.properties = properties;
    }
}

