/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnProperty(prefix="wx.open.config-storage", name={"type"}, havingValue="jedis")
@ConditionalOnClass(value={JedisPool.class, JedisPoolConfig.class})
public class WxOpenInRedisConfigStorageConfiguration {
    private final WxOpenProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenInRedisConfigStorage config = this.getWxOpenInRedisConfigStorage();
        WxOpenProperties.ConfigStorage configStorageProperties = this.properties.getConfigStorage();
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisConfigStorage() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        JedisPool jedisPool = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        return new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxOpenInRedisConfigStorageConfiguration(WxOpenProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

