/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisConfigStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="wx.open.config-storage", name={"type"}, havingValue="redistemplate")
@ConditionalOnClass(value={StringRedisTemplate.class})
public class WxOpenInRedisTemplateConfigStorageConfiguration {
    private final WxOpenProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenInRedisConfigStorage config = this.getWxOpenInRedisTemplateConfigStorage();
        WxOpenProperties.ConfigStorage configStorageProperties = this.properties.getConfigStorage();
        config.setWxOpenInfo(this.properties.getAppId(), this.properties.getSecret(), this.properties.getToken(), this.properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        return config;
    }

    private WxOpenInRedisConfigStorage getWxOpenInRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        return new WxOpenInRedisConfigStorage((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
    }

    public WxOpenInRedisTemplateConfigStorageConfiguration(WxOpenProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

