/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.config.storage.AbstractWxOpenConfigStorageConfiguration;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenRedisProperties;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedissonConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="wx.open.config-storage", name={"type"}, havingValue="redisson")
@ConditionalOnClass(value={Redisson.class, RedissonClient.class})
public class WxOpenInRedissonConfigStorageConfiguration
extends AbstractWxOpenConfigStorageConfiguration {
    private final WxOpenProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenInRedissonConfigStorage config = this.getWxOpenInRedissonConfigStorage();
        return this.config((WxOpenInMemoryConfigStorage)config, this.properties);
    }

    private WxOpenInRedissonConfigStorage getWxOpenInRedissonConfigStorage() {
        WxOpenRedisProperties wxOpenRedisProperties = this.properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = wxOpenRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxOpenRedisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxOpenInRedissonConfigStorage(redissonClient, this.properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxOpenProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxOpenRedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxOpenInRedissonConfigStorageConfiguration(WxOpenProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

