/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.config.storage.AbstractWxOpenConfigStorageConfiguration;
import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenInRedisTemplateConfigStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="wx.open.config-storage", name={"type"}, havingValue="redistemplate")
@ConditionalOnClass(value={StringRedisTemplate.class})
public class WxOpenInRedisTemplateConfigStorageConfiguration
extends AbstractWxOpenConfigStorageConfiguration {
    private final WxOpenProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxOpenConfigStorage.class})
    public WxOpenConfigStorage wxOpenConfigStorage() {
        WxOpenInRedisTemplateConfigStorage config = this.getWxOpenInRedisTemplateConfigStorage();
        return this.config((WxOpenInMemoryConfigStorage)config, this.properties);
    }

    private WxOpenInRedisTemplateConfigStorage getWxOpenInRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        return new WxOpenInRedisTemplateConfigStorage(redisTemplate, this.properties.getConfigStorage().getKeyPrefix());
    }

    public WxOpenInRedisTemplateConfigStorageConfiguration(WxOpenProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

