/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.open.config.storage;

import com.binarywang.spring.starter.wxjava.open.properties.WxOpenProperties;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWxOpenConfigStorageConfiguration {
    protected WxOpenInMemoryConfigStorage config(WxOpenInMemoryConfigStorage config, WxOpenProperties properties) {
        int retrySleepMillis;
        int maxRetryTimes;
        WxOpenProperties.ConfigStorage storage = properties.getConfigStorage();
        config.setWxOpenInfo(properties.getAppId(), properties.getSecret(), properties.getToken(), properties.getAesKey());
        config.setHttpProxyHost(storage.getHttpProxyHost());
        config.setHttpProxyUsername(storage.getHttpProxyUsername());
        config.setHttpProxyPassword(storage.getHttpProxyPassword());
        Integer httpProxyPort = storage.getHttpProxyPort();
        if (httpProxyPort != null) {
            config.setHttpProxyPort(httpProxyPort.intValue());
        }
        if ((maxRetryTimes = storage.getMaxRetryTimes()) < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        config.setRetrySleepMillis(retrySleepMillis);
        config.setMaxRetryTimes(maxRetryTimes);
        config.setApiHostUrl(StringUtils.trimToNull((String)properties.getApiHostUrl()));
        config.setAccessTokenUrl(StringUtils.trimToNull((String)properties.getAccessTokenUrl()));
        ApacheHttpClientBuilder clientBuilder = config.getApacheHttpClientBuilder();
        if (clientBuilder == null) {
            clientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        if (clientBuilder instanceof DefaultApacheHttpClientBuilder) {
            DefaultApacheHttpClientBuilder defaultBuilder = (DefaultApacheHttpClientBuilder)clientBuilder;
            defaultBuilder.setConnectionTimeout(storage.getConnectionTimeout());
            defaultBuilder.setSoTimeout(storage.getSoTimeout());
            defaultBuilder.setConnectionRequestTimeout(storage.getConnectionRequestTimeout());
            config.setApacheHttpClientBuilder((ApacheHttpClientBuilder)defaultBuilder);
        }
        return config;
    }
}

