/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.pay.config;

import com.binarywang.solon.wxjava.pay.properties.WxPayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
@Condition(onProperty="${wx.pay.enabled:true} = true", onClass=WxPayService.class)
public class WxPayAutoConfiguration {
    private WxPayProperties properties;

    public WxPayAutoConfiguration(WxPayProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Condition(onMissingBean=WxPayService.class)
    public WxPayService wxPayService() {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getMchKey()));
        payConfig.setSubAppId(StringUtils.trimToNull((String)this.properties.getSubAppId()));
        payConfig.setSubMchId(StringUtils.trimToNull((String)this.properties.getSubMchId()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getKeyPath()));
        payConfig.setUseSandboxEnv(this.properties.isUseSandboxEnv());
        payConfig.setServiceId(StringUtils.trimToNull((String)this.properties.getServiceId()));
        payConfig.setPayScoreNotifyUrl(StringUtils.trimToNull((String)this.properties.getPayScoreNotifyUrl()));
        payConfig.setPrivateKeyPath(StringUtils.trimToNull((String)this.properties.getPrivateKeyPath()));
        payConfig.setPrivateCertPath(StringUtils.trimToNull((String)this.properties.getPrivateCertPath()));
        payConfig.setCertSerialNo(StringUtils.trimToNull((String)this.properties.getCertSerialNo()));
        payConfig.setApiV3Key(StringUtils.trimToNull((String)this.properties.getApiv3Key()));
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }
}

