/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Optional;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;

public class ApexFileHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexFileHelper.class);
    private static Path applicationTemporaryFolder;

    private static synchronized void initParentTmpFolder() throws IOException {
        applicationTemporaryFolder = Files.createTempDirectory("apex", new FileAttribute[0]);
    }

    protected ApexFileHelper() {
    }

    public static File getResourceFile(String path) {
        try {
            return new ClassPathResource(path).getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getResourceURL(String path) {
        try {
            return new ClassPathResource(path).getURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getResourcePath(String path) {
        try {
            return new ClassPathResource(path).getFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Beta
    public static Path createTempFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    public static Path createTempPath(String prefix, String suffix) throws IOException {
        String fileName;
        Path tmpFilePath;
        if (applicationTemporaryFolder == null) {
            ApexFileHelper.initParentTmpFolder();
        }
        if ((tmpFilePath = applicationTemporaryFolder.resolve(fileName = prefix + UUID.randomUUID() + suffix)).toFile().exists()) {
            throw new IllegalStateException("We failed creating a non-existing tmp file");
        }
        return tmpFilePath;
    }

    public static Path createTestPath(String prefix, String suffix) throws IOException {
        return ApexFileHelper.createTestPath(prefix, suffix, true);
    }

    public static Path createTestPath(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        Path testPath = ApexFileHelper.createTempPath(prefix, suffix);
        if (deleteOnExit) {
            testPath.toFile().deleteOnExit();
        }
        return testPath;
    }

    public static String cleanWhitespaces(String mdx) {
        if (Strings.isNullOrEmpty((String)mdx)) {
            return "";
        }
        return mdx.replaceAll("\\s+", " ");
    }

    @Beta
    public static void expandJarToDisk(Path jarPath, Path targetPath) throws IOException {
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> enumEntries = jar.entries();
            File destDir = targetPath.toFile();
            destDir.mkdirs();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                Path diskPath = targetPath.resolve(file.getName());
                if (file.isDirectory()) {
                    if (diskPath.toFile().mkdir()) continue;
                    throw new IllegalStateException("Failed creating " + file);
                }
                diskPath.getParent().toFile().mkdirs();
                InputStream is = jar.getInputStream(file);
                Throwable throwable = null;
                try {
                    Files.copy(is, diskPath, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    public static Optional<Path> getHoldingJarPath(URL resource) throws IOException {
        if (resource.getProtocol().equals("jar")) {
            String path = resource.getPath();
            int indexOfInsideJar = path.indexOf("!/");
            DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
            if (indexOfInsideJar == -1) {
                return Optional.of(defaultResourceLoader.getResource(resource.toString()).getFile().toPath());
            }
            String jarOnly = path.substring(0, indexOfInsideJar);
            return Optional.of(defaultResourceLoader.getResource(jarOnly).getFile().toPath());
        }
        return Optional.empty();
    }

    static {
        try {
            ApexFileHelper.initParentTmpFolder();
        }
        catch (IOException e) {
            LOGGER.error("Failure while creating a top tmp folder", (Throwable)e);
            applicationTemporaryFolder = null;
        }
    }
}

