/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ApexGzipHelper {
    private static final int GZIP_MAGIC_SHIFT = 8;

    protected ApexGzipHelper() {
    }

    public static boolean isGZIPStream(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117;
    }

    public static String toStringOptCompressed(byte[] bytes) throws IOException {
        if (ApexGzipHelper.isGZIPStream(bytes)) {
            return ApexGzipHelper.toStringCompressed(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String toStringCompressed(byte[] bytes) throws IOException {
        return ApexGzipHelper.inflate(bytes);
    }

    @Deprecated
    public static byte[] compress(String someString) throws IOException {
        return ApexGzipHelper.deflate(someString);
    }

    public static byte[] deflate(String someString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), StandardCharsets.UTF_8);){
            osw.write(someString);
        }
        return baos.toByteArray();
    }

    public static String inflate(byte[] inflated) throws IOException {
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(inflated));
        InputStreamReader osw = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);
        return CharStreams.toString((Readable)osw);
    }
}

