/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.jmx;

import blasd.apex.core.io.ApexSerializationHelper;
import blasd.apex.core.stream.ApexStreamHelper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ApexJMXHelper {
    public static final String JMX_DEFAULT_STRING = "String";
    public static final String STANDARD_DEFAULT_STRING = "";
    public static final int JMX_DEFAULT_INT = 0;
    public static final int DEFAULT_LIMIT = 400;

    protected ApexJMXHelper() {
    }

    public static String convertToString(String asString) {
        if (asString == null || asString.isEmpty() || JMX_DEFAULT_STRING.equals(asString)) {
            return STANDARD_DEFAULT_STRING;
        }
        return asString.trim();
    }

    public static Map<String, String> convertToMap(String asString) {
        if ((asString = ApexJMXHelper.convertToString(asString)).isEmpty()) {
            return Collections.emptyMap();
        }
        return ApexSerializationHelper.convertToMapStringString(asString);
    }

    public static Map<String, List<String>> convertToMapList(String asString) {
        if ((asString = ApexJMXHelper.convertToString(asString)).isEmpty()) {
            return Collections.emptyMap();
        }
        return ApexSerializationHelper.convertToMapStringListString(asString);
    }

    public static List<? extends Map<String, String>> convertToJMXListMapString(Iterable<? extends Map<String, ?>> iterator) {
        Iterable asString = Iterables.transform(iterator, input -> new TreeMap(Maps.transformValues((Map)input, String::valueOf)));
        return Lists.newArrayList((Iterable)asString);
    }

    public static List<String> convertToList(String asString) {
        if ((asString = ApexJMXHelper.convertToString(asString)).isEmpty()) {
            return Collections.emptyList();
        }
        return ApexSerializationHelper.convertToListString(asString);
    }

    public static Set<?> convertToSet(String asString) {
        if ((asString = ApexJMXHelper.convertToString(asString)).isEmpty()) {
            return Collections.emptySet();
        }
        return ApexSerializationHelper.convertToSet(asString);
    }

    public static Set<? extends String> convertToSetString(String asString) {
        if ((asString = ApexJMXHelper.convertToString(asString)).isEmpty()) {
            return Collections.emptySet();
        }
        return ApexSerializationHelper.convertToSetString(asString);
    }

    public static Map<String, String> convertToJMXMapString(Map<?, ?> someMap) {
        LinkedHashMap<String, String> idToQueryString = new LinkedHashMap<String, String>();
        for (Map.Entry<?, ?> entry : someMap.entrySet()) {
            idToQueryString.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return idToQueryString;
    }

    public static <T> Map<String, T> convertToJMXMapKeyString(Map<?, T> someMap) {
        LinkedHashMap<String, T> idToQueryString = new LinkedHashMap<String, T>();
        for (Map.Entry<?, T> entry : someMap.entrySet()) {
            idToQueryString.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return idToQueryString;
    }

    public static <S, T> Map<S, T> convertToJMXMap(Map<S, T> asMap) {
        Map<S, T> cleanerMap;
        try {
            cleanerMap = new TreeMap<S, T>(asMap);
        }
        catch (RuntimeException e) {
            cleanerMap = asMap;
        }
        return ApexJMXHelper.convertToJMXValueOrderedMap(cleanerMap, Optional.empty());
    }

    public static <S, T extends Comparable<T>> Map<S, T> convertToJMXValueOrderedMap(Map<S, T> map) {
        return ApexJMXHelper.convertToJMXValueOrderedMap(map, false);
    }

    public static <S, T extends Comparable<T>> Map<S, T> convertToJMXValueOrderedMap(Map<S, T> map, boolean reverse) {
        Comparator comparator = reverse ? Map.Entry.comparingByValue().reversed() : Map.Entry.comparingByValue();
        return ApexJMXHelper.convertToJMXValueOrderedMap(map, Optional.of(comparator));
    }

    public static <S, T> Map<S, T> convertToJMXValueOrderedMap(Map<S, T> map, Optional<? extends Comparator<? super Map.Entry<S, T>>> comparator) {
        Supplier<Map> mapSupplier;
        Stream<Object> entries = map.entrySet().stream();
        if (comparator.isPresent()) {
            entries = entries.sorted(comparator.get());
            mapSupplier = LinkedHashMap::new;
        } else {
            mapSupplier = map instanceof TreeMap ? TreeMap::new : LinkedHashMap::new;
        }
        return entries.collect(ApexStreamHelper.toMap(e -> {
            if (e.getKey() instanceof List) {
                return ApexJMXHelper.convertToJMXList((List)e.getKey());
            }
            return e.getKey();
        }, Map.Entry::getValue, mapSupplier));
    }

    public static <T extends Comparable<T>> Set<T> convertToJMXSet(Iterable<? extends T> elements) {
        return Sets.newTreeSet(elements);
    }

    public static <T> List<T> convertToJMXList(Iterable<? extends T> elements) {
        return Lists.newArrayList(elements);
    }

    public static <T> Collection<T> convertToJMXCollection(Iterable<? extends T> elements) {
        if (elements instanceof Set) {
            return Sets.newLinkedHashSet(elements);
        }
        return Lists.newArrayList(elements);
    }

    public static List<String> convertToJMXStringList(Iterable<?> elements) {
        return ApexJMXHelper.convertToJMXList(Iterables.transform(elements, (Function)Functions.toStringFunction()));
    }

    public static List<String> convertToJMXStringSet(Set<?> elements) {
        return ApexJMXHelper.convertToJMXList(Iterables.transform(elements, (Function)Functions.toStringFunction()));
    }

    public static int convertToLimit(int limit) {
        if (limit == 0) {
            return 400;
        }
        return limit;
    }

    public static URL convertToURL(String url) throws MalformedURLException {
        if (Strings.isNullOrEmpty((String)(url = ApexJMXHelper.convertToString(url)))) {
            return null;
        }
        Objects.requireNonNull(url);
        if (new File(url).exists()) {
            return new File(url).toURI().toURL();
        }
        return new URL(url.replaceAll(" ", "%20"));
    }
}

