/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.logging;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ApexLogHelper {
    private static final long HUNDRED = 100L;
    protected static final int BARRIER_FOR_SIZE_IN_LOG = 10;
    public static final int THOUSAND = 1000;
    public static final int TEN_F = 10;
    private static final long LIMIT_ENTRY_PER_XXX = 10L;
    private static final String HOURS_PREFIX = "hours";
    private static final String MINUTES_PREFIX = "min";
    private static final String SECONDS_PREFIX = "sec";
    private static final String MILLIS_PREFIX = "ms";

    protected ApexLogHelper() {
    }

    public static Object lazyToString(final Supplier<String> toStringMe) {
        return new Object(){

            public String toString() {
                return (String)toStringMe.get();
            }
        };
    }

    public static Object getNicePercentage(long progress, long max) {
        return ApexLogHelper.lazyToString(() -> {
            if (progress < 0L || max <= 0L) {
                return "-%";
            }
            long ratio = progress * 100L / max;
            if (ratio == 0L) {
                long smallRatio = progress * 1000L / max;
                if (smallRatio == 0L) {
                    long verySmallRatio = progress * 100L * 100L / max;
                    return "0.0" + Long.toString(verySmallRatio) + "%";
                }
                return "0." + Long.toString(smallRatio) + "%";
            }
            if (ratio < 10L) {
                long smallRatio = (progress - ratio * 10L) * 1000L / max;
                return ratio + "." + Long.toString(smallRatio) + "%";
            }
            return Long.toString(ratio) + "%";
        });
    }

    public static Object getNiceMemory(long size) {
        return ApexLogHelper.lazyToString(() -> {
            long absSize = Math.abs(size);
            if (absSize < 10240L) {
                return size + "B";
            }
            if (absSize < 0xA00000L) {
                return size / 1024L + "KB";
            }
            if (absSize < 0x280000000L) {
                return size / 0x100000L + "MB";
            }
            if (absSize < 0xA0000000000L) {
                return size / 0x40000000L + "GB";
            }
            return size / 0x10000000000L + "TB";
        });
    }

    public static Object getObjectAndClass(Object o) {
        return ApexLogHelper.lazyToString(() -> {
            if (o == null) {
                return null + "(null)";
            }
            return o.toString() + "(" + o.getClass().getName() + ")";
        });
    }

    public static Object getToStringWithLimit(Iterable<?> iterable, int limitSize) {
        return ApexLogHelper.lazyToString(() -> {
            if (iterable == null) {
                return null + "(null)";
            }
            int size = Iterables.size((Iterable)iterable);
            if (size <= limitSize) {
                return iterable.toString();
            }
            return "[" + Streams.stream((Iterable)iterable).limit(limitSize).map(Object::toString).collect(Collectors.joining(", ")) + ", (" + (size - limitSize) + " more elements)]";
        });
    }

    public static Object getNiceDouble(Double value) {
        if (value == null) {
            return "null";
        }
        return ApexLogHelper.lazyToString(() -> {
            String pattern = ".##";
            DecimalFormat myFormatter = new DecimalFormat(".##");
            return myFormatter.format(value);
        });
    }

    public static Object getNiceTime(long timeInMs) {
        return ApexLogHelper.getNiceTime(timeInMs, TimeUnit.MILLISECONDS);
    }

    public static Object getNiceTime(long time, TimeUnit timeUnit) {
        return ApexLogHelper.lazyToString(() -> {
            long timeInMs = timeUnit.toMillis(time);
            if (timeInMs >= TimeUnit.HOURS.toMillis(1L)) {
                String minString = TimeUnit.MILLISECONDS.toHours(timeInMs) + HOURS_PREFIX;
                long minutes = timeInMs - TimeUnit.HOURS.toMillis(1L) * TimeUnit.MILLISECONDS.toHours(timeInMs);
                if (minutes > 0L) {
                    return minString + " " + TimeUnit.MILLISECONDS.toMinutes(minutes) + MINUTES_PREFIX;
                }
                return minString;
            }
            if (timeInMs >= TimeUnit.MINUTES.toMillis(1L)) {
                String minString = TimeUnit.MILLISECONDS.toMinutes(timeInMs) + MINUTES_PREFIX;
                long seconds = timeInMs - TimeUnit.MINUTES.toMillis(1L) * TimeUnit.MILLISECONDS.toMinutes(timeInMs);
                if (seconds > 0L) {
                    return minString + " " + TimeUnit.MILLISECONDS.toSeconds(seconds) + SECONDS_PREFIX;
                }
                return minString;
            }
            if (timeInMs >= TimeUnit.SECONDS.toMillis(1L)) {
                String minString = TimeUnit.MILLISECONDS.toSeconds(timeInMs) + SECONDS_PREFIX;
                long millis = timeInMs - TimeUnit.SECONDS.toMillis(1L) * TimeUnit.MILLISECONDS.toSeconds(timeInMs);
                if (millis > 0L) {
                    return minString + " " + millis + MILLIS_PREFIX;
                }
                return minString;
            }
            return timeInMs + MILLIS_PREFIX;
        });
    }

    public static Object getNiceRate(long nbEntries, long time, TimeUnit timeUnit) {
        return ApexLogHelper.lazyToString(() -> {
            if (time <= 0L) {
                return nbEntries + "#/0" + (Object)((Object)timeUnit);
            }
            long entryPerSecond = TimeUnit.SECONDS.convert(nbEntries / time, timeUnit);
            if (entryPerSecond > 10L) {
                long entryPerMinute = TimeUnit.MINUTES.convert(nbEntries / time, timeUnit);
                if (entryPerMinute > 10L) {
                    return entryPerMinute + "#/minute";
                }
                return entryPerSecond + "#/second";
            }
            long nbSeconds = TimeUnit.SECONDS.convert(time, timeUnit);
            if (nbSeconds > 0L) {
                long entryPerSecond2 = nbEntries / nbSeconds;
                return entryPerSecond2 + "#/second";
            }
            long entryPerNano = TimeUnit.NANOSECONDS.convert(nbEntries, timeUnit) / time;
            long entryPerSecond2 = TimeUnit.SECONDS.convert(entryPerNano, TimeUnit.NANOSECONDS);
            if (entryPerSecond2 > 0L) {
                return entryPerSecond2 + "#/second";
            }
            long entryPerMillis = TimeUnit.MILLISECONDS.convert(entryPerNano, TimeUnit.NANOSECONDS);
            return entryPerMillis + "#/ms";
        });
    }
}

