/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory;

import blasd.apex.core.memory.IApexMemoryConstants;
import blasd.apex.server.monitoring.memory.InstrumentationAgent;
import com.google.common.base.CharMatcher;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.util.concurrent.AtomicLongMap;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ApexMemoryHelper
implements IApexMemoryConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexMemoryHelper.class);
    public static final int NB_STRING_BEFORE_CLEAR = 10000;
    private static final ConcurrentMap<Class<?>, List<Field>> CLASS_TO_ELECTED_FIELDS = new ConcurrentHashMap();
    private static final ConcurrentMap<Field, ConcurrentMap<Object, Object>> DICTIONARY = new ConcurrentHashMap<Field, ConcurrentMap<Object, Object>>();
    private static final AtomicLongMap<Field> FIELD_TO_DICTIONARY_SIZE = AtomicLongMap.create();
    public static final int JVM_MEMORY_CHUNK = 8;
    public static final int JVM_BYTES_PER_CHAR = 2;
    public static final int JVM_STRING_HEADER = 45;
    private static final long MASK = 0xFFFFFFFFL;
    private static final int SHIFT = 32;

    protected ApexMemoryHelper() {
    }

    public static void dictionarize(Object data) {
        if (data == null) {
            return;
        }
        Class<?> clazz = data.getClass();
        List<Field> fields = ApexMemoryHelper.computeDictionarizableFields(clazz);
        if (fields.isEmpty()) {
            return;
        }
        for (Field f : fields) {
            ApexMemoryHelper.dictionarizeFieldValue(f, data);
        }
    }

    protected static void dictionarizeFieldValue(Field field, Object object) {
        if (field == null || object == null) {
            return;
        }
        ConcurrentMap fieldDictionary = (ConcurrentMap)DICTIONARY.get(field);
        if (fieldDictionary == null) {
            DICTIONARY.putIfAbsent(field, new ConcurrentHashMap());
            fieldDictionary = (ConcurrentMap)DICTIONARY.get(field);
        }
        try {
            Object currentRef = field.get(object);
            if (currentRef != null) {
                Object existingRef = fieldDictionary.putIfAbsent(currentRef, currentRef);
                if (existingRef != null && existingRef != currentRef) {
                    field.set(object, existingRef);
                } else {
                    if (existingRef instanceof CharSequence) {
                        FIELD_TO_DICTIONARY_SIZE.addAndGet((Object)field, ApexMemoryHelper.getStringMemory((CharSequence)existingRef));
                    }
                    if (fieldDictionary.size() > 10000) {
                        fieldDictionary.clear();
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            ApexMemoryHelper.stopDictionarizing(object.getClass(), field);
        }
        catch (IllegalAccessException e) {
            ApexMemoryHelper.stopDictionarizing(object.getClass(), field);
        }
    }

    public static long getStringMemory(CharSequence existingRef) {
        int nbChars = existingRef.length();
        return 8 * ((nbChars * 2 + 45) / 8);
    }

    protected static void stopDictionarizing(Class<?> clazz, Field field) {
        if (clazz == null || field == null) {
            return;
        }
        List electedFields = (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
        if (electedFields != null) {
            electedFields.remove(field);
        }
        DICTIONARY.remove(field);
    }

    protected static List<Field> computeDictionarizableFields(Class<?> clazz) {
        List fields = (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
        if (fields != null) {
            return fields;
        }
        CopyOnWriteArrayList preparingFields = new CopyOnWriteArrayList();
        ReflectionUtils.doWithFields(clazz, field -> {
            ReflectionUtils.makeAccessible((Field)field);
            preparingFields.add(field);
        }, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            return field.getType() == String.class;
        });
        CLASS_TO_ELECTED_FIELDS.putIfAbsent(clazz, preparingFields);
        return (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
    }

    public static <T> void dictionarizeArray(T[] array) {
        if (array == null) {
            return;
        }
        for (T item : array) {
            ApexMemoryHelper.dictionarize(item);
        }
    }

    public static void dictionarizeIterable(Iterable<?> iterable) {
        if (iterable == null) {
            return;
        }
        for (Object item : iterable) {
            ApexMemoryHelper.dictionarize(item);
        }
    }

    @Deprecated
    public static long recursiveSize(Object object) {
        return ApexMemoryHelper.deepSize(object);
    }

    public static long deepSize(Object object) {
        return ApexMemoryHelper.deepSizeWithBloomFilter(object, 0x1FFFFFL);
    }

    public static long recursiveSize(Object object, IntPredicate identityPredicate) {
        return ApexMemoryHelper.deepSize(object, identityPredicate);
    }

    public static long deepSize(Object object, IntPredicate identityPredicate) {
        if (object == null) {
            return 0L;
        }
        Instrumentation instrumentation = InstrumentationAgent.safeGetInstrumentation();
        if (instrumentation == null) {
            LOGGER.debug("Instrumentation is not available");
            return 0L;
        }
        LongAdder totalSize = new LongAdder();
        ApexMemoryHelper.deepSize(instrumentation, identityPredicate, totalSize, object);
        return totalSize.sum();
    }

    @Deprecated
    public static long recursiveSizeWithBloomFilter(Object object, long expectedObjectCardinality) {
        return ApexMemoryHelper.deepSizeWithBloomFilter(object, expectedObjectCardinality);
    }

    public static long deepSizeWithBloomFilter(Object object, long expectedObjectCardinality) {
        BloomFilter identities = BloomFilter.create((Funnel)Funnels.integerFunnel(), (long)expectedObjectCardinality);
        return ApexMemoryHelper.recursiveSize(object, arg_0 -> ((BloomFilter)identities).put(arg_0));
    }

    @Deprecated
    public static void recursiveSize(Instrumentation instrumentation, IntPredicate identities, LongAdder totalSize, Object object) {
        ApexMemoryHelper.deepSize(instrumentation, identities, totalSize, object);
    }

    public static void deepSize(Instrumentation instrumentation, IntPredicate identities, LongAdder totalSize, Object object) {
        if (object == null) {
            return;
        }
        if (identities.test(System.identityHashCode(object))) {
            long currentSize = instrumentation.getObjectSize(object);
            totalSize.add(currentSize);
            if (object instanceof Object[]) {
                Arrays.stream((Object[])object).forEach(element -> ApexMemoryHelper.recursiveSize(instrumentation, identities, totalSize, element));
            } else {
                ReflectionUtils.doWithFields(object.getClass(), field -> ApexMemoryHelper.recursiveSize(instrumentation, identities, totalSize, field.get(object)), field -> {
                    if (Modifier.isStatic(field.getModifiers())) {
                        return false;
                    }
                    if (field.getType().isPrimitive()) {
                        return false;
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    return true;
                });
            }
        }
    }

    public static long getDoubleMemory() {
        long charArrayWeight = 16L;
        return charArrayWeight;
    }

    public static long getObjectArrayMemory(Object[] asArray) {
        if (asArray == null) {
            return 0L;
        }
        long footprint = 8L;
        return footprint += 8L * (long)asArray.length;
    }

    public static long getObjectArrayMemory(Object asArray) {
        if (asArray == null) {
            return 0L;
        }
        Class<?> arrayClass = asArray.getClass();
        if (!arrayClass.isArray()) {
            return 0L;
        }
        Class<?> elementClass = arrayClass.getComponentType();
        long footprint = 8L;
        long componentWeight = elementClass == Integer.TYPE ? 4L : (elementClass == Float.TYPE ? 4L : 8L);
        return footprint += componentWeight * (long)Array.getLength(asArray);
    }

    public static final long positivePack(int i1, int i2) {
        long packed1 = (long)i1 << 32;
        long packed2 = (long)Integer.rotateLeft(i2, 1) & 0xFFFFFFFFL;
        return Long.rotateRight(packed1 | packed2, 1);
    }

    public static final int positiveUnpack1(long packed) {
        return (int)(Long.rotateLeft(packed, 1) >>> 32);
    }

    public static final int positiveUnpack2(long packed) {
        return Integer.rotateRight((int)(Long.rotateLeft(packed, 1) & 0xFFFFFFFFL), 1);
    }

    public static long memoryAsLong(String targetMax) {
        String digits;
        long multiplier;
        if (targetMax.isEmpty()) {
            throw new UnsupportedOperationException("Can not be empty");
        }
        char lastChar = targetMax.charAt(targetMax.length() - 1);
        if (CharMatcher.javaDigit().matches(lastChar)) {
            multiplier = 1L;
            digits = targetMax;
        } else {
            if (lastChar == 'k' || lastChar == 'K') {
                multiplier = 1024L;
            } else if (lastChar == 'm' || lastChar == 'M') {
                multiplier = 0x100000L;
            } else if (lastChar == 'g' || lastChar == 'G') {
                multiplier = 0x40000000L;
            } else {
                throw new IllegalArgumentException("Can not parse " + targetMax + ". It should end by a digit or one of 'k', 'm','g'");
            }
            digits = targetMax.substring(0, targetMax.length() - 1);
        }
        return Long.parseLong(digits) * multiplier;
    }
}

