/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory.histogram;

import blasd.apex.core.memory.histogram.ClassInfo;
import blasd.apex.core.memory.histogram.ClassInfoComparator;
import blasd.apex.core.memory.histogram.IHeapHistogram;
import blasd.apex.server.monitoring.memory.VirtualMachineWithoutToolsJar;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class HeapHistogram
implements IHeapHistogram,
Serializable {
    private static final long serialVersionUID = 2163916067335213382L;
    private final List<ClassInfo> classes;
    private final List<ClassInfo> permGenClasses;
    private final Date time = new Date();
    private long totalHeapBytes;
    private long totalHeapInstances;
    private long totalPermGenBytes;
    private long totalPermgenInstances;
    private boolean sourceDisplayed;
    private static final int DECIMAL_RADIX = 10;

    HeapHistogram(InputStream in, boolean jrockit) {
        Scanner sc = new Scanner(in, JMAP_CHARSET.toString());
        List<ClassInfo> classInfos = this.scan(sc, jrockit);
        this.classes = new ArrayList<ClassInfo>();
        this.permGenClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : classInfos) {
            if (classInfo.isPermGen()) {
                this.permGenClasses.add(classInfo);
                this.totalPermGenBytes += classInfo.getBytes();
                this.totalPermgenInstances += classInfo.getInstancesCount();
            } else {
                this.classes.add(classInfo);
                this.totalHeapBytes += classInfo.getBytes();
                this.totalHeapInstances += classInfo.getInstancesCount();
            }
            if (this.sourceDisplayed || classInfo.getSource() == null) continue;
            this.sourceDisplayed = true;
        }
        if (!jrockit) {
            sc.next("Total");
            long totalInstances = sc.nextLong();
            long totalBytes = sc.nextLong();
            assert (totalInstances == this.totalPermgenInstances + this.totalHeapInstances);
            assert (totalBytes == this.totalPermGenBytes + this.totalHeapBytes);
        }
        this.sort();
    }

    private void addClassInfo(ClassInfo newClInfo, Map<String, ClassInfo> map) {
        ClassInfo oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.add(newClInfo);
        }
    }

    protected Date getTime() {
        return this.time;
    }

    protected List<ClassInfo> getHeapHistogram() {
        return Collections.unmodifiableList(this.classes);
    }

    protected long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    @Override
    public long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    List<ClassInfo> getPermGenHistogram() {
        return Collections.unmodifiableList(this.permGenClasses);
    }

    long getTotalPermGenInstances() {
        return this.totalPermgenInstances;
    }

    long getTotalPermGenBytes() {
        return this.totalPermGenBytes;
    }

    boolean isSourceDisplayed() {
        return this.sourceDisplayed;
    }

    private void sort() {
        Comparator<ClassInfo> classInfoReversedComparator = Collections.reverseOrder(new ClassInfoComparator());
        Collections.sort(this.permGenClasses, classInfoReversedComparator);
        Collections.sort(this.classes, classInfoReversedComparator);
    }

    protected void skipHeader(Scanner sc, boolean jrockit) {
        sc.nextLine();
        sc.nextLine();
        if (!jrockit) {
            sc.skip("-+");
            sc.nextLine();
        }
    }

    protected List<ClassInfo> scan(Scanner sc, boolean jrockit) {
        HashMap<String, ClassInfo> classInfoMap = new HashMap<String, ClassInfo>();
        sc.useRadix(10);
        this.skipHeader(sc, jrockit);
        String nextLine = jrockit ? "[0-9.]+%" : "[0-9]+:";
        while (sc.hasNext(nextLine)) {
            ClassInfo newClInfo = new ClassInfo(sc, jrockit);
            this.addClassInfo(newClInfo, classInfoMap);
        }
        return new ArrayList<ClassInfo>(classInfoMap.values());
    }

    public static HeapHistogram createHeapHistogram() throws Exception {
        try (InputStream input = VirtualMachineWithoutToolsJar.heapHisto();){
            HeapHistogram heapHistogram = new HeapHistogram(input, VirtualMachineWithoutToolsJar.isJRockit());
            return heapHistogram;
        }
    }

    public static String createHeapHistogramAsString() throws Exception {
        byte[] byteArray = ByteStreams.toByteArray((InputStream)VirtualMachineWithoutToolsJar.heapHisto());
        return new String(byteArray, JMAP_CHARSET);
    }

    public static long saveHeapDump(File file, boolean gzipped) throws Exception {
        try (InputStream input = VirtualMachineWithoutToolsJar.heapDump();){
            InputStream wrapped = gzipped ? new GZIPInputStream(input) : input;
            long l = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(wrapped);
            return l;
        }
    }
}

