/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexStreamHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexStreamHelper.class);

    protected ApexStreamHelper() {
    }

    @Deprecated
    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return Streams.stream(iterator);
    }

    @Deprecated
    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return Streams.stream(iterable);
    }

    public static <T> Stream<T> singleton(T item) {
        return Collections.singleton(item).stream();
    }

    @Beta
    public static <T> OptionalInt indexOf(List<T> list, Predicate<T> predicate) {
        return IntStream.range(0, list.size()).filter(i -> predicate.apply(list.get(i))).findFirst();
    }

    @Beta
    public static <T> long consumeByPartition(Stream<T> stream, Consumer<Queue<T>> consumer, int partitionSize) {
        return ApexStreamHelper.consumeByPartition(() -> new ArrayBlockingQueue(partitionSize), stream, consumer);
    }

    @Deprecated
    @Beta
    public static <T> long consumeByPartition(Supplier<? extends BlockingQueue<T>> queueSupplier, Stream<T> stream, Consumer<Queue<T>> consumer) {
        AtomicLong nbConsumed = new AtomicLong();
        Queue leftOvers = stream.collect(queueSupplier, (queue, tuple) -> {
            queue.add(tuple);
            if (queue.remainingCapacity() == 0) {
                consumer.accept((Queue<Queue>)queue);
                nbConsumed.addAndGet(queue.size());
                queue.clear();
            }
        }, (l, r) -> {
            int nbDrained = r.drainTo(l, l.remainingCapacity());
            while (!r.isEmpty()) {
                consumer.accept((Queue<Queue>)l);
                nbConsumed.addAndGet(l.size());
                l.clear();
                nbDrained += r.drainTo(l);
            }
            if (nbDrained < 0) {
                LOGGER.trace("nbDrained: {}", (Object)nbDrained);
            }
        });
        consumer.accept(leftOvers);
        nbConsumed.addAndGet(leftOvers.size());
        return nbConsumed.get();
    }

    public static <T> Stream<T> emptyStream() {
        return Collections.emptyList().stream();
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, ApexStreamHelper.throwingMerger(), mapSupplier);
    }
}

