/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.BloomFilterStrategies;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class BloomFilterSpy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterSpy.class);
    private static final Field BIT_ARRAY_FIELD = ReflectionUtils.findField(BloomFilter.class, (String)"bits", BloomFilterStrategies.BitArray.class);
    private static final Field NUM_HASH_FUNCTIONS_FIELD = ReflectionUtils.findField(BloomFilter.class, (String)"numHashFunctions", Integer.TYPE);

    protected BloomFilterSpy() {
    }

    public static long estimateCardinality(BloomFilter<?> bloomFilter) {
        if (bloomFilter == null) {
            return 0L;
        }
        if (BIT_ARRAY_FIELD == null || NUM_HASH_FUNCTIONS_FIELD == null) {
            LOGGER.warn("BloomFilter.estimateCardinality is not available");
            return -1L;
        }
        try {
            BloomFilterStrategies.BitArray bitArray = (BloomFilterStrategies.BitArray)ReflectionUtils.getField((Field)BIT_ARRAY_FIELD, bloomFilter);
            long x = bitArray.bitCount();
            if (x == 0L) {
                return 0L;
            }
            long m = bitArray.bitSize();
            long k = NUM_HASH_FUNCTIONS_FIELD.getInt(bloomFilter);
            long theory = (long)((double)(-1L * m) * Math.log(1.0 - (double)x / (double)m)) / k;
            return Math.max(1L, theory);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            if (BIT_ARRAY_FIELD != null) {
                ReflectionUtils.makeAccessible((Field)BIT_ARRAY_FIELD);
            }
            if (NUM_HASH_FUNCTIONS_FIELD != null) {
                ReflectionUtils.makeAccessible((Field)NUM_HASH_FUNCTIONS_FIELD);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Issue with BloomFilter introspection", t);
        }
    }
}

