/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.metrics;

import blasd.apex.core.io.ApexFileHelper;
import blasd.apex.core.logging.ApexLogHelper;
import blasd.apex.core.metrics.EndMetricEvent;
import blasd.apex.core.metrics.IApexMetricsTowerControl;
import blasd.apex.core.metrics.StartMetricEvent;
import blasd.apex.core.thread.ApexExecutorsHelper;
import blasd.apex.core.thread.IApexThreadDumper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class ApexMetricsTowerControl
implements IApexMetricsTowerControl,
InitializingBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexMetricsTowerControl.class);
    public static final String PATH_JOINER = ".";
    public static final int CACHE_TIMEOUT_MINUTES = 60;
    public static final int CACHE_MAX_SIZE = 1000;
    public static final int DEFAULT_LONGRUNNINGCHECK_SECONDS = 10;
    protected int longRunningCheckSeconds = 10;
    private static final int FACTOR_FOR_OLD = 3;
    private static final int FACTOR_FOR_TOO_OLD = 12;
    protected final LoadingCache<StartMetricEvent, LocalDateTime> activeTasks;
    protected final LoadingCache<StartMetricEvent, StartMetricEvent> verySlowTasks;
    protected final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();
    protected final ScheduledExecutorService logLongRunningES = ApexExecutorsHelper.newSingleThreadScheduledExecutor(this.getClass().getSimpleName());
    protected final IApexThreadDumper apexThreadDumper;

    public ApexMetricsTowerControl(IApexThreadDumper apexThreadDumper) {
        this.apexThreadDumper = apexThreadDumper;
        this.activeTasks = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(ApexExecutorsHelper.DEFAULT_ACTIVE_TASKS).removalListener(removal -> {
            if (removal.getCause().equals((Object)RemovalCause.EXPIRED)) {
                this.logOnFarTooMuchLongTask((StartMetricEvent)removal.getKey());
            } else if (removal.getCause().equals((Object)RemovalCause.EXPLICIT)) {
                this.logOnEndEvent((StartMetricEvent)removal.getKey());
            }
        }).build(CacheLoader.from(key -> LocalDateTime.now()));
        this.verySlowTasks = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(ApexExecutorsHelper.DEFAULT_ACTIVE_TASKS).build(CacheLoader.from(startEvent -> startEvent));
    }

    protected void logOnFarTooMuchLongTask(StartMetricEvent startEvent) {
        String threadDump = this.apexThreadDumper.getSmartThreadDumpAsString(false);
        LOGGER.error("Task still active after {} {}. We stop monitoring it: {}. ThreadDump: {}", new Object[]{60, TimeUnit.MINUTES, startEvent, threadDump});
    }

    protected void logOnDetectingVeryLongTask(StartMetricEvent startEvent) {
        String threadDump = this.apexThreadDumper.getSmartThreadDumpAsString(false);
        LOGGER.error("Very-Long task: {} ThreadDump: {}", (Object)startEvent, (Object)threadDump);
    }

    protected void logOnEndEvent(StartMetricEvent startEvent) {
        Optional<EndMetricEvent> endEvent = startEvent.getEndEvent();
        if (!endEvent.isPresent()) {
            LOGGER.info("We closed {} without an endEvent ?!", (Object)startEvent);
        } else {
            long longRunningInMillis;
            long timeInMs = endEvent.get().durationInMs();
            if (timeInMs > 12L * (longRunningInMillis = TimeUnit.SECONDS.toMillis(this.longRunningCheckSeconds))) {
                LOGGER.warn("Very-long {} ended", ApexLogHelper.lazyToString(() -> ((EndMetricEvent)endEvent.get()).startEvent.toStringNoStack()));
            } else if (timeInMs > longRunningInMillis) {
                LOGGER.info("Long {} ended", ApexLogHelper.lazyToString(() -> ((EndMetricEvent)endEvent.get()).startEvent.toStringNoStack()));
            } else {
                LOGGER.trace("{} ended", ApexLogHelper.lazyToString(() -> ((EndMetricEvent)endEvent.get()).startEvent.toStringNoStack()));
            }
        }
    }

    @Override
    @ManagedAttribute
    public int getLongRunningCheckSeconds() {
        return this.longRunningCheckSeconds;
    }

    @Override
    @ManagedAttribute
    public void setLongRunningCheckSeconds(int longRunningCheckSeconds) {
        this.longRunningCheckSeconds = longRunningCheckSeconds;
        if (this.scheduledFuture.get() != null) {
            this.scheduleLogLongRunningTasks();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduleLogLongRunningTasks();
    }

    protected void scheduleLogLongRunningTasks() {
        ScheduledFuture<?> cancelMe = this.scheduledFuture.getAndSet(this.logLongRunningES.scheduleWithFixedDelay(() -> this.logLongRunningTasks(), 1L, this.longRunningCheckSeconds, TimeUnit.SECONDS));
        if (cancelMe != null) {
            cancelMe.cancel(true);
        }
    }

    protected void logLongRunningTasks() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oldBarrier = now.minusSeconds(this.longRunningCheckSeconds);
        LocalDateTime tooOldBarrier = now.minusSeconds(3 * this.longRunningCheckSeconds);
        LocalDateTime muchtooOldBarrier = now.minusSeconds(12 * this.longRunningCheckSeconds);
        String logMessage = "Task active since ({}) {}: {}";
        for (Map.Entry active : this.activeTasks.asMap().entrySet()) {
            LocalDateTime activeSince = (LocalDateTime)active.getValue();
            int seconds = Seconds.secondsBetween((ReadablePartial)activeSince, (ReadablePartial)now).getSeconds();
            Object time = ApexLogHelper.getNiceTime(seconds, TimeUnit.SECONDS);
            StartMetricEvent startEvent = (StartMetricEvent)active.getKey();
            Object cleanKey = this.noNewLine(startEvent);
            if (activeSince.isBefore((ReadablePartial)muchtooOldBarrier)) {
                LOGGER.warn(logMessage, new Object[]{time, activeSince, cleanKey});
                this.verySlowTasks.refresh((Object)startEvent);
                continue;
            }
            if (activeSince.isBefore((ReadablePartial)tooOldBarrier)) {
                LOGGER.info(logMessage, new Object[]{time, activeSince, cleanKey});
                continue;
            }
            if (activeSince.isBefore((ReadablePartial)oldBarrier)) {
                LOGGER.debug(logMessage, new Object[]{time, activeSince, cleanKey});
                continue;
            }
            LOGGER.trace(logMessage, new Object[]{time, activeSince, cleanKey});
        }
    }

    protected Object noNewLine(StartMetricEvent key) {
        return ApexLogHelper.lazyToString(() -> ApexFileHelper.cleanWhitespaces(key.toString()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onStartEvent(StartMetricEvent startEvent) {
        if (startEvent.source == null) {
            LOGGER.debug("Discard StartEvent which is missing a Source: {}", (Object)startEvent);
        } else {
            this.activeTasks.getUnchecked((Object)startEvent);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEndEvent(EndMetricEvent endEvent) {
        long timeInMs = endEvent.durationInMs();
        if (timeInMs < 0L) {
            LOGGER.debug("An EndEvent has been submitted without its StartEvent Context having been started: {}", (Object)endEvent);
        } else {
            this.invalidateStartEvent(endEvent.startEvent);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onThrowable(Throwable t) {
        LOGGER.error("Not managed exception", t);
    }

    protected void invalidateStartEvent(StartMetricEvent startEvent) {
        if (this.activeTasks.getIfPresent((Object)startEvent) == null) {
            LOGGER.debug("And EndEvent has been submitted without its StartEvent having been registered, or after having been already invalidated: {}", (Object)startEvent);
        } else {
            this.invalidate(startEvent);
        }
    }

    @Override
    @ManagedAttribute
    public long getActiveTasksSize() {
        return this.activeTasks.size();
    }

    @Override
    @ManagedAttribute
    public long getRootActiveTasksSize() {
        Set startMetricEvent = this.activeTasks.asMap().keySet();
        return startMetricEvent.stream().map(s -> {
            Object root = s.getDetail("RootSource");
            if (root == null) {
                return s.source;
            }
            return root;
        }).distinct().count();
    }

    @Override
    @ManagedAttribute
    public NavigableMap<Date, String> getActiveTasks() {
        return this.convertToMapDateString(this.activeTasks.asMap());
    }

    protected NavigableMap<Date, String> convertToMapDateString(ConcurrentMap<?, LocalDateTime> asMap) {
        TreeMap<Date, String> dateToName = new TreeMap<Date, String>();
        for (Map.Entry entry : asMap.entrySet()) {
            Date dateToInsert = ((LocalDateTime)entry.getValue()).toDate();
            while (dateToName.containsKey(dateToInsert)) {
                dateToInsert = new Date(dateToInsert.getTime() + 1L);
            }
            String fullName = String.valueOf(entry.getKey());
            dateToName.put(dateToInsert, fullName);
        }
        return dateToName;
    }

    @ManagedOperation
    public boolean invalidateActiveTasks(String name) {
        for (StartMetricEvent startEvent : this.activeTasks.asMap().keySet()) {
            if (!name.equals(startEvent.toStringNoStack())) continue;
            this.invalidate(startEvent);
            return true;
        }
        return false;
    }

    protected void invalidate(StartMetricEvent startEvent) {
        this.activeTasks.invalidate((Object)startEvent);
        this.verySlowTasks.invalidate((Object)startEvent);
    }

    @ManagedOperation
    public void setDoRememberStack(boolean doRememberStack) {
        StartMetricEvent.setDoRememberStack(doRememberStack);
    }

    @ManagedOperation
    public String getAllThreads(boolean withoutMonitors) {
        return this.apexThreadDumper.getThreadDumpAsString(!withoutMonitors);
    }
}

