/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import blasd.apex.core.collection.NavigableMapComparator;
import blasd.apex.core.collection.NavigableMapListValueComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsafeNavigableMapListValueComparator
implements Comparator<NavigableMap<?, ? extends List<?>>>,
Serializable {
    private static final long serialVersionUID = 7928339315645573854L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(NavigableMapComparator.class);
    protected static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object key, Object key2) {
            if (key == key2) {
                return 0;
            }
            if (key instanceof Comparable) {
                if (key2 instanceof Comparable) {
                    return ((Comparable)key).compareTo(key2);
                }
                throw new RuntimeException(key2 + " is not Comparable");
            }
            throw new RuntimeException(key + " is not Comparable");
        }
    };
    protected static final Comparator<List<?>> LIST_VALUES_COMPARATOR = new Comparator<List<?>>(){

        @Override
        public int compare(List<?> key, List<?> key2) {
            int commonDepth = Math.min(key.size(), key2.size());
            for (int i = 0; i < commonDepth; ++i) {
                int compareResult = KEY_COMPARATOR.compare(key.get(i), key2.get(i));
                if (compareResult == 0) continue;
                return compareResult;
            }
            if (key.size() == key2.size()) {
                return 0;
            }
            return key.size() - key2.size();
        }
    };

    @Override
    public int compare(NavigableMap<?, ? extends List<?>> o1, NavigableMap<?, ? extends List<?>> o2) {
        return NavigableMapListValueComparator.staticCompare(o1, o2, KEY_COMPARATOR, LIST_VALUES_COMPARATOR);
    }
}

