/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory.histogram;

import java.io.Serializable;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 6283636454450216347L;
    private static Map<Character, String> arrayTypes = new HashMap<Character, String>();
    private long instances;
    private long bytes;
    private final String jvmName;
    private final String name;
    private final boolean permGen;
    private final String source;

    ClassInfo(Scanner sc, boolean jrockit) {
        sc.next();
        if (jrockit) {
            this.bytes = ClassInfo.parseLongWithK(sc.next());
            this.instances = sc.nextLong();
        } else {
            this.instances = sc.nextLong();
            this.bytes = sc.nextLong();
        }
        this.jvmName = sc.next();
        this.permGen = this.jvmName.charAt(0) == '<';
        this.name = this.convertJVMName();
        this.source = this.findSource();
    }

    void add(ClassInfo classInfo) {
        assert (this.getName().equals(classInfo.getName()));
        this.bytes += classInfo.getBytes();
        this.instances += classInfo.getInstancesCount();
    }

    String getName() {
        return this.name;
    }

    long getInstancesCount() {
        return this.instances;
    }

    long getBytes() {
        return this.bytes;
    }

    boolean isPermGen() {
        return this.permGen;
    }

    String getSource() {
        return this.source;
    }

    private String findSource() {
        if (this.jvmName.endsWith("Klass>") || this.jvmName.startsWith("sun.reflect.")) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.jvmName);
            return ClassInfo.findSource(clazz);
        }
        catch (LinkageError e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String findSource(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null) {
            String src = codeSource.getLocation().toString();
            if (src.startsWith("file:/")) {
                src = src.substring("file:/".length());
            } else if (src.startsWith("vfs:/")) {
                src = src.substring("vfs:/".length());
            } else if (src.startsWith("reference:file:/")) {
                src = src.substring("reference:file:/".length());
            }
            if (src.endsWith(".jar") || src.endsWith(".war")) {
                src = src.intern();
            }
            return src;
        }
        return null;
    }

    private String convertJVMName() {
        String result;
        int index = this.jvmName.lastIndexOf(91);
        if (index != -1) {
            char code = this.jvmName.charAt(index + 1);
            if (code == 'L') {
                result = this.jvmName.substring(index + 2, this.jvmName.length() - 1);
            } else {
                result = arrayTypes.get(Character.valueOf(code));
                if (result == null) {
                    result = this.jvmName;
                }
            }
            StringBuilder sb = new StringBuilder(result);
            for (int i = 0; i <= index; ++i) {
                sb.append("[]");
            }
            result = sb.toString();
        } else {
            result = this.jvmName;
        }
        return result.intern();
    }

    static long parseLongWithK(String text) {
        assert (text.length() > 0);
        if (text.charAt(text.length() - 1) == 'k') {
            String t = text.substring(0, text.length() - 1);
            if (t.charAt(0) == '+') {
                t = t.substring(1);
            }
            return 1024L * Long.parseLong(t);
        }
        return Long.parseLong(text);
    }

    static {
        arrayTypes.put(Character.valueOf('Z'), "boolean");
        arrayTypes.put(Character.valueOf('C'), "char");
        arrayTypes.put(Character.valueOf('B'), "byte");
        arrayTypes.put(Character.valueOf('S'), "short");
        arrayTypes.put(Character.valueOf('I'), "int");
        arrayTypes.put(Character.valueOf('J'), "long");
        arrayTypes.put(Character.valueOf('F'), "float");
        arrayTypes.put(Character.valueOf('D'), "double");
        arrayTypes.put(Character.valueOf('L'), "object");
    }
}

