/*
 * Decompiled with CFR 0.152.
 */
package io.cormoran.buffer;

import com.google.common.annotations.Beta;
import java.lang.reflect.InvocationTargetException;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CloseableIntBuffer
implements AutoCloseable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CloseableIntBuffer.class);
    protected final MappedByteBuffer buffer;
    protected final IntBuffer heapBuffer;

    public CloseableIntBuffer(MappedByteBuffer buffer) {
        this.buffer = buffer;
        this.heapBuffer = null;
    }

    public CloseableIntBuffer(IntBuffer heapBuffer) {
        this.heapBuffer = heapBuffer;
        this.buffer = null;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            try {
                Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                Object cleaner = directBufferClass.getMethod("cleaner", new Class[0]).invoke((Object)this.buffer, new Object[0]);
                Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
                cleanerClass.getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.trace("Ouch", (Throwable)e);
                return;
            }
        }
    }

    public IntBuffer asIntBuffer() {
        if (this.heapBuffer != null) {
            return this.heapBuffer;
        }
        return this.buffer.asIntBuffer();
    }
}

