/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexCachePathMatcher
implements PathMatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexCachePathMatcher.class);
    protected final Map<String, Boolean> alreadyLogged = new ConcurrentHashMap<String, Boolean>();
    protected final PathMatcher decorated;
    protected final String pattern;

    public ApexCachePathMatcher(PathMatcher decorated, String pattern) {
        this.decorated = decorated;
        this.pattern = pattern;
    }

    @Override
    public boolean matches(Path path) {
        String cacheKey = path.toString();
        boolean match = this.alreadyLogged.computeIfAbsent(cacheKey, key -> {
            boolean matches = this.decorated.matches(path);
            LOGGER.debug("PathMatcher {} on {} returned {}", new Object[]{this.pattern, path, matches});
            return matches;
        });
        LOGGER.trace("PathMatcher {} on {} returned {}", new Object[]{this.pattern, path, match});
        return match;
    }

    public String toString() {
        return this.pattern;
    }
}

