/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.io.ApexCachePathMatcher;
import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ApexFileHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexFileHelper.class);
    private static final String GLOB_PREFIX = "glob:";
    private static final String GLOB_MATCH_ANY_ALL = "**";

    protected ApexFileHelper() {
    }

    public static Path getResourceAsPath(Resource resource) {
        try {
            if (resource.exists()) {
                try {
                    return resource.getFile().toPath();
                }
                catch (FileNotFoundException e) {
                    Path tmpFile = Files.createTempFile("ApexFileHelper", resource.getFilename(), new FileAttribute[0]);
                    byte[] from = ByteStreams.toByteArray((InputStream)resource.getInputStream());
                    Files.write(tmpFile, from, new OpenOption[0]);
                    return tmpFile;
                }
            }
            return resource.getFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getResourceURL(String path) {
        try {
            return new ClassPathResource(path).getURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path createTempPath(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        File asFile = path.toFile();
        if (asFile.exists()) {
            LOGGER.trace("Tmp file exists: delete it as we have been requested for a path");
            if (!asFile.delete()) {
                throw new IllegalStateException("We failed creating a non-existing tmp file");
            }
        }
        if (deleteOnExit) {
            asFile.deleteOnExit();
        }
        return path;
    }

    public static String cleanWhitespaces(String mdx) {
        if (Strings.isNullOrEmpty((String)mdx)) {
            return "";
        }
        return mdx.replaceAll("\\s+", " ");
    }

    @Beta
    public static void expandJarToDisk(Path jarPath, Path targetPath) throws IOException {
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> enumEntries = jar.entries();
            File destDir = targetPath.toFile();
            destDir.mkdirs();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                Path diskPath = targetPath.resolve(file.getName());
                if (file.isDirectory()) {
                    if (diskPath.toFile().mkdir()) continue;
                    throw new IllegalStateException("Failed creating " + file);
                }
                diskPath.getParent().toFile().mkdirs();
                InputStream is = jar.getInputStream(file);
                Throwable throwable = null;
                try {
                    Files.copy(is, diskPath, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    public static Optional<Path> getHoldingJarPath(URI resource) throws IOException {
        if (resource.getScheme().toLowerCase().equals("jar")) {
            String path = resource.getRawSchemeSpecificPart();
            int indexOfInsideJar = path.indexOf("!/");
            DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
            if (indexOfInsideJar == -1) {
                return Optional.of(defaultResourceLoader.getResource(resource.toString()).getFile().toPath());
            }
            String jarOnly = path.substring(0, indexOfInsideJar);
            return Optional.of(defaultResourceLoader.getResource(jarOnly).getFile().toPath());
        }
        return Optional.empty();
    }

    public static Path resolveToPath(ResourceLoader resourceLoader, String pathToFileOrFolder) {
        Path directoryAsPath;
        if (Strings.isNullOrEmpty((String)pathToFileOrFolder)) {
            throw new IllegalArgumentException("We are missing an environment variable: " + pathToFileOrFolder);
        }
        boolean forceTryAsSpringResource = false;
        try {
            directoryAsPath = Paths.get(pathToFileOrFolder, new String[0]);
        }
        catch (InvalidPathException e) {
            LOGGER.trace("This seems not an absolute path", (Throwable)e);
            forceTryAsSpringResource = true;
            directoryAsPath = null;
        }
        if (forceTryAsSpringResource || !directoryAsPath.toFile().exists()) {
            try {
                Resource resource = resourceLoader.getResource(pathToFileOrFolder);
                if (!resource.exists()) {
                    throw new IllegalArgumentException("Not able to find " + pathToFileOrFolder);
                }
                directoryAsPath = resource.getFile().toPath();
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Not able to parse " + pathToFileOrFolder, e1);
            }
        }
        return directoryAsPath;
    }

    public static PathMatcher makePathMatcher(String globPathMatcher, boolean matchAnySubdirectory) {
        String fullGlobPattern;
        if (globPathMatcher.startsWith(GLOB_PREFIX)) {
            fullGlobPattern = globPathMatcher;
        } else {
            String relativeGLobPathMatcher = matchAnySubdirectory ? "**/" + globPathMatcher : globPathMatcher;
            String finalPathMatcher = relativeGLobPathMatcher.replaceAll("\\\\", "/");
            fullGlobPattern = GLOB_PREFIX + finalPathMatcher;
        }
        PathMatcher decorated = FileSystems.getDefault().getPathMatcher(fullGlobPattern);
        return new ApexCachePathMatcher(decorated, fullGlobPattern);
    }
}

