/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.jmx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.ReflectionUtils;

@ManagedResource
public class SetStaticMBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SetStaticMBean.class);
    protected boolean forceForPrivateFinal = true;

    @ManagedOperation
    public void setStatic(String className, String fieldName, String newValueAsString) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> classToSet = Class.forName(className);
        Field field = this.getField(classToSet, fieldName);
        Class<?> fieldType = field.getType();
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            field.set(null, Boolean.parseBoolean(newValueAsString));
        } else if (fieldType == Float.class || fieldType == Float.TYPE) {
            field.set(null, Float.valueOf(Float.parseFloat(newValueAsString)));
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            field.set(null, Double.parseDouble(newValueAsString));
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            field.set(null, Integer.parseInt(newValueAsString));
        } else if (fieldType == Long.class || fieldType == Long.TYPE) {
            field.set(null, Long.parseLong(newValueAsString));
        } else if (fieldType == String.class) {
            field.set(null, newValueAsString);
        } else {
            Object asObject = SetStaticMBean.safeTrySingleArgConstructor(fieldType, newValueAsString);
            if (asObject != null) {
                field.set(null, asObject);
                return;
            }
            throw new RuntimeException("The field " + fieldType + " is not managed");
        }
    }

    @ManagedOperation
    public String getStaticAsString(String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return String.valueOf(this.getStatic(className, fieldName));
    }

    public Object getStatic(String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> classToSet = Class.forName(className);
        Field field = this.getField(classToSet, fieldName);
        return field.get(null);
    }

    private Field getField(Class<?> classToSet, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionUtils.findField(classToSet, (String)fieldName);
        if (this.forceForPrivateFinal) {
            ReflectionUtils.makeAccessible((Field)field);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            ReflectionUtils.makeAccessible((Field)modifiersField);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        return field;
    }

    public static Object safeTrySingleArgConstructor(Class<?> fieldType, Object argument) {
        if (argument == null) {
            return null;
        }
        for (Class<?> classToTry = argument.getClass(); classToTry != null; classToTry = classToTry.getSuperclass()) {
            Object asObject = SetStaticMBean.safeTrySingleArgConstructor(fieldType, classToTry, argument);
            if (asObject == null) continue;
            return asObject;
        }
        for (Class<?> classToTry : argument.getClass().getInterfaces()) {
            Object asObject = SetStaticMBean.safeTrySingleArgConstructor(fieldType, classToTry, argument);
            if (asObject != null) {
                return asObject;
            }
            classToTry = classToTry.getSuperclass();
        }
        return null;
    }

    public static Object safeTrySingleArgConstructor(Class<?> fieldType, Class<?> constructorClass, Object argument) {
        try {
            Constructor<?> stringConstructor = fieldType.getConstructor(constructorClass);
            return stringConstructor.newInstance(argument);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            LOGGER.trace("No constructor for {} with {} argumennt", fieldType, constructorClass);
            return null;
        }
    }

    @ManagedOperation
    public List<String> getResourcesFor(String path) throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        Enumeration<URL> urlEnum = this.getClass().getClassLoader().getResources(path);
        if (!urlEnum.hasMoreElements()) {
            urlEnum = this.getClass().getClassLoader().getResources(path.replace('.', '/') + ".class");
        }
        while (urlEnum.hasMoreElements()) {
            resources.add(urlEnum.nextElement().toString());
        }
        return resources;
    }
}

