/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.primitive;

import blasd.apex.core.primitive.ConcatCharSequence;
import blasd.apex.core.primitive.Jdk9CharSequenceParsers;
import com.google.common.base.CharMatcher;

public class ApexParserHelper {
    private static double[] pow10;
    private static final CharMatcher E_UPPER_MATCHER;
    private static final CharMatcher PLUS_MATCHER;
    private static final CharMatcher MINUS_MATCHER;
    private static final CharMatcher E_LOWER_MATCHER;
    private static final CharMatcher DOT_MATCHER;

    public static synchronized void initialize() {
        pow10 = new double[634];
        for (int i = 0; i < pow10.length; ++i) {
            ApexParserHelper.pow10[i] = Double.parseDouble("1.0e" + (i - 325));
        }
    }

    public static double parseDouble(CharSequence s) {
        int n;
        if (pow10 == null) {
            ApexParserHelper.initialize();
        }
        if (s.charAt(0) == 'N' && s.charAt(1) == 'a' && s.charAt(2) == 'N') {
            return Double.NaN;
        }
        if (s.charAt(0) == 'I' && s.charAt(1) == 'n' && s.charAt(2) == 'f' && s.charAt(3) == 'i' && s.charAt(4) == 'n' && s.charAt(5) == 'i' && s.charAt(6) == 't' && s.charAt(7) == 'y') {
            return Double.POSITIVE_INFINITY;
        }
        if (s.charAt(0) == '-' && s.charAt(1) == 'I' && s.charAt(2) == 'n' && s.charAt(3) == 'f' && s.charAt(4) == 'i' && s.charAt(5) == 'n' && s.charAt(6) == 'i' && s.charAt(7) == 't' && s.charAt(8) == 'y') {
            return Double.POSITIVE_INFINITY;
        }
        int first = 0;
        int last = s.length();
        if (PLUS_MATCHER.matches(s.charAt(0))) {
            first = 1;
        }
        int exp = 0;
        int e = E_UPPER_MATCHER.indexIn(s);
        if (e < 0) {
            e = E_LOWER_MATCHER.indexIn(s);
        }
        if (e >= 0) {
            int expStart = PLUS_MATCHER.matches(s.charAt(e + 1)) ? e + 2 : e + 1;
            exp = Jdk9CharSequenceParsers.parseShort(s, expStart, last, 10);
            last = e;
        } else if (PLUS_MATCHER.lastIndexIn(s) > 0 || MINUS_MATCHER.lastIndexIn(s) > 0) {
            throw new RuntimeException("Not a number");
        }
        int p = DOT_MATCHER.indexIn(s);
        if (p >= 0) {
            while (first < p && s.charAt(first) == '0') {
                ++first;
            }
            while (last > p + 1 && s.charAt(last - 1) == '0') {
                --last;
            }
            if (last == p + 1) {
                last = p;
                n = last - first;
                exp += n - 1;
            } else {
                exp += p - 1 - first;
                n = last - first - 1;
                if (first == p) {
                    first = p + 1;
                } else {
                    s = new ConcatCharSequence(s.subSequence(first, p), s.subSequence(p + 1, last));
                    first = 0;
                }
            }
        } else {
            n = last - first;
            exp += n - 1;
        }
        if (n == 0) {
            return 0.0;
        }
        double intermediate = n > 17 ? (double)Jdk9CharSequenceParsers.parseLong(s, first, 17 + first, 10) * pow10[309] : (n < 9 ? (double)Jdk9CharSequenceParsers.parseInt(s, first, first + n, 10) * pow10[326 - n] : (double)Jdk9CharSequenceParsers.parseLong(s, first, first + n, 10) * pow10[326 - n]);
        return intermediate * pow10[exp + 325];
    }

    public static float parseFloat(CharSequence floatAsCharSequence) {
        return (float)ApexParserHelper.parseDouble(floatAsCharSequence);
    }

    static {
        E_UPPER_MATCHER = CharMatcher.is((char)'E').precomputed();
        PLUS_MATCHER = CharMatcher.is((char)'+').precomputed();
        MINUS_MATCHER = CharMatcher.is((char)'-').precomputed();
        E_LOWER_MATCHER = CharMatcher.is((char)'e').precomputed();
        DOT_MATCHER = CharMatcher.is((char)'.').precomputed();
    }
}

