/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.thread;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OfferWithTimeoutPolicy
implements RejectedExecutionHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OfferWithTimeoutPolicy.class);
    protected int timeout;
    protected TimeUnit unit;
    protected final AtomicBoolean isGoingToLog = new AtomicBoolean();

    public OfferWithTimeoutPolicy(int timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        block7: {
            if (this.isGoingToLog.compareAndSet(false, true)) {
                try {
                    long start = System.currentTimeMillis();
                    boolean result = executor.getQueue().offer(() -> {
                        r.run();
                        long time = System.currentTimeMillis() - start;
                        if (time > 1000L) {
                            LOGGER.warn("The pool {} is full and it took {} ms for the first rejected task to be processed", (Object)executor, (Object)time);
                        }
                        this.isGoingToLog.set(false);
                    }, this.timeout, this.unit);
                    if (!result) {
                        throw new RuntimeException("We failed pushing the task " + r + " after waiting " + this.timeout + (Object)((Object)this.unit));
                    }
                    break block7;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.isGoingToLog.set(false);
                    throw new RejectedExecutionException("Task " + r.toString() + " rejected", e);
                }
            }
            try {
                boolean result = executor.getQueue().offer(r, this.timeout, this.unit);
                if (!result) {
                    throw new RuntimeException("We failed pushing the task " + r + " after waiting " + this.timeout + (Object)((Object)this.unit));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Task " + r.toString() + " rejected", e);
            }
        }
    }
}

