/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexGzipHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexGzipHelper.class);
    private static final int GZIP_MAGIC_SHIFT = 8;

    protected ApexGzipHelper() {
    }

    public static boolean isGZIPStream(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117;
    }

    public static String toStringOptCompressed(byte[] bytes) throws IOException {
        if (ApexGzipHelper.isGZIPStream(bytes)) {
            return ApexGzipHelper.toStringCompressed(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String toStringCompressed(byte[] bytes) throws IOException {
        return ApexGzipHelper.inflate(bytes);
    }

    @Deprecated
    public static byte[] compress(String someString) throws IOException {
        return ApexGzipHelper.deflate(someString);
    }

    public static byte[] deflate(String someString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), StandardCharsets.UTF_8);){
            osw.write(someString);
        }
        return baos.toByteArray();
    }

    public static String inflate(byte[] inflated) throws IOException {
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(inflated));
        InputStreamReader osw = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);
        return CharStreams.toString((Readable)osw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packToZip(File folder, File zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File next : Files.fileTreeTraverser().preOrderTraversal((Object)folder)) {
                if (next.isDirectory()) {
                    zos.putNextEntry(new ZipEntry(folder.toURI().relativize(next.toURI()).getPath() + "/"));
                    zos.closeEntry();
                    continue;
                }
                if (!next.isFile()) continue;
                LOGGER.debug("Adding {} in {}", (Object)next, (Object)zipFilePath);
                zos.putNextEntry(new ZipEntry(folder.toURI().relativize(next.toURI()).getPath()));
                Files.copy((File)next, (OutputStream)zos);
                zos.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packToGzip(File inputPath, File zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             GZIPOutputStream zos = new GZIPOutputStream(fos);){
            Files.copy((File)inputPath, (OutputStream)zos);
        }
    }
}

