/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.io.ByteArrayMarker;
import blasd.apex.core.io.ObjectInputHandlingInputStream;
import blasd.apex.core.memory.IApexMemoryConstants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexObjectStreamHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexObjectStreamHelper.class);
    @VisibleForTesting
    static final int DEFAULT_CHUNK_SIZE = IApexMemoryConstants.KB_INT;

    protected ApexObjectStreamHelper() {
    }

    public static long writeInputStream(ObjectOutput objectOutput, InputStream inputStream) throws IOException {
        return ApexObjectStreamHelper.writeInputStream(objectOutput, inputStream, DEFAULT_CHUNK_SIZE);
    }

    public static long writeInputStream(ObjectOutput objectOutput, InputStream inputStream, int chunkSize) throws IOException {
        int nbToCopy;
        byte[] buffer = new byte[chunkSize];
        long totalWritten = 0L;
        while ((nbToCopy = ByteStreams.read((InputStream)inputStream, (byte[])buffer, (int)0, (int)buffer.length)) != 0) {
            objectOutput.writeObject(new ByteArrayMarker(nbToCopy, false));
            objectOutput.write(buffer, 0, nbToCopy);
            LOGGER.trace("We have transmitted {} bytes", (Object)(totalWritten += (long)nbToCopy));
        }
        objectOutput.writeObject(new ByteArrayMarker(0L, true));
        objectOutput.write(buffer, 0, 0);
        return totalWritten;
    }

    public static ObjectInput wrapToHandleInputStream(ObjectInput objectInput) {
        return new ObjectInputHandlingInputStream(objectInput);
    }
}

