/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.io.ByteArrayMarker;
import blasd.apex.core.thread.ApexExecutorsHelper;
import com.google.common.primitives.Ints;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInputHandlingInputStream
implements ObjectInput {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ObjectInputHandlingInputStream.class);
    protected final ObjectInput decorated;
    protected final ExecutorService inputStreamFiller;
    protected final AtomicBoolean pipedOutputStreamIsOpen = new AtomicBoolean(false);
    protected final AtomicReference<Exception> ouch = new AtomicReference();

    public ObjectInputHandlingInputStream(ObjectInput decorated) {
        this(decorated, (ExecutorService)ApexExecutorsHelper.newSingleThreadExecutor("ObjectInputHandling"));
    }

    public ObjectInputHandlingInputStream(ObjectInput decorated, ExecutorService inputStreamFiller) {
        this.decorated = decorated;
        this.inputStreamFiller = inputStreamFiller;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        if (this.pipedOutputStreamIsOpen.get()) {
            throw new RuntimeException("We can not read next object as previous was an InputStream which has not been flushed yet");
        }
        this.rethrowException();
        Object next = this.decorated.readObject();
        if (next instanceof ByteArrayMarker) {
            CountDownLatch connectedCdl = new CountDownLatch(1);
            PipedInputStream pis = new PipedInputStream();
            if (!this.pipedOutputStreamIsOpen.compareAndSet(false, true)) {
                throw new IllegalStateException("Pipe was already open");
            }
            this.inputStreamFiller.execute(() -> {
                block22: {
                    try (PipedOutputStream pos = new PipedOutputStream(pis);){
                        Object localNext;
                        connectedCdl.countDown();
                        ByteArrayMarker nextByteMarker = (ByteArrayMarker)next;
                        while (true) {
                            byte[] bytes = new byte[Ints.checkedCast((long)nextByteMarker.getNbBytes())];
                            try {
                                this.decorated.readFully(bytes);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failure while retrieveing a chunk with nbBytes=" + nextByteMarker.getNbBytes(), e);
                            }
                            pos.write(bytes);
                            if (nextByteMarker.getIsFinished()) {
                                break block22;
                            }
                            localNext = this.decorated.readObject();
                            if (!(localNext instanceof ByteArrayMarker)) break;
                            nextByteMarker = (ByteArrayMarker)localNext;
                        }
                        throw new IllegalStateException("We received ByteArrayMarker with isFinished=false while next object was a " + localNext);
                    }
                    catch (IOException | ClassNotFoundException | RuntimeException e) {
                        if (!this.ouch.compareAndSet(null, e)) {
                            throw new RuntimeException("We encountered a new exception while previous one has not been reported", e);
                        }
                        LOGGER.warn("Multiple issues in " + this, (Throwable)e);
                    }
                    finally {
                        this.pipedOutputStreamIsOpen.set(false);
                    }
                }
            });
            try {
                if (!connectedCdl.await(1L, TimeUnit.MINUTES)) {
                    pis.close();
                    throw new RuntimeException("It took too long to connect the pipes");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            return pis;
        }
        return next;
    }

    protected void rethrowException() throws EOFException, IOException {
        Exception pendingException = this.ouch.getAndSet(null);
        if (pendingException != null) {
            if (pendingException instanceof EOFException) {
                throw (EOFException)pendingException;
            }
            if (pendingException instanceof IOException) {
                throw new IOException(pendingException);
            }
            throw new RuntimeException(pendingException);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.decorated.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.decorated.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.decorated.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.decorated.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.decorated.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.decorated.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.decorated.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.decorated.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.decorated.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.decorated.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.decorated.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.decorated.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.decorated.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.decorated.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.decorated.readUTF();
    }

    @Override
    public int read() throws IOException {
        return this.decorated.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.decorated.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.decorated.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.decorated.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.decorated.available();
    }

    @Override
    public void close() throws IOException {
        this.decorated.close();
    }
}

